/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.log.LogConfig$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tmg\u0001B\u0013'\u0001-BQa\r\u0001\u0005\u0002QBqA\u000e\u0001C\u0002\u0013\u0005s\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\u0006\u007f\u0001!\t\u0006\u0011\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019A\u0006\u0001)A\u0005!\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006BB2\u0001A\u0003%1\fC\u0004e\u0001\t\u0007I\u0011B3\t\rA\u0004\u0001\u0015!\u0003g\u0011\u0015\t\b\u0001\"\u0015s\u0011\u001dY\bA1A\u0005RqDq!!\u0004\u0001A\u0003%Q\u0010\u0003\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0015}\u0011\u001d\t\t\u0002\u0001Q\u0001\nuDq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002<\u0001!\t%!\u0010\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002>!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\b\u0003\u001b\u0003A\u0011BAH\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!!5\u0001\t\u0013\t\u0019\u000eC\u0004\u0002d\u0002!I!!:\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9\u0011q\u001f\u0001\u0005\n\u0005e\bbBA\u007f\u0001\u0011%\u0011q \u0005\n\u0005\u0017\u0002\u0011\u0013!C\u0005\u0005\u001bBqAa\u001a\u0001\t\u0013\u0011I\u0007C\u0004\u0003\u0004\u0002!IA!\"\t\u0013\te\u0005!%A\u0005\n\t=\u0003b\u0002BN\u0001\u0011%!Q\u0014\u0005\b\u0005C\u0003A\u0011\u0002BR\u0011\u001d\u0011i\f\u0001C\u0005\u0005\u007fC\u0011B!4\u0001#\u0003%IAa4\t\u000f\tM\u0007\u0001\"\u0003\u0003V\nYQ*\u001a;sS\u000e\u001cH+Z:u\u0015\t9\u0003&A\u0002ba&T\u0011!K\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001A\u0006\r\t\u0003[9j\u0011AJ\u0005\u0003_\u0019\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o\u001d\t\u0003[EJ!A\r\u0014\u0003\u0013M\u000b7\u000f\\*fiV\u0004\u0018A\u0002\u001fj]&$h\bF\u00016!\ti\u0003!A\u0006ce>\\WM]\"pk:$X#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u0007%sG/\u0001\u0007ce>\\WM]\"pk:$\b%\u0001\u0007mSN$XM\\3s\u001d\u0006lW-F\u0001B!\t\u0011E*D\u0001D\u0015\t!U)A\u0004oKR<xN]6\u000b\u0005\u0019;\u0015AB2p[6|gN\u0003\u0002*\u0011*\u0011\u0011JS\u0001\u0007CB\f7\r[3\u000b\u0003-\u000b1a\u001c:h\u0013\ti5I\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\u0012\u0001\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001\\1oO*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\u0019\u0019FO]5oO\u0006I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003m\u00032\u0001X1Q\u001b\u0005i&B\u00010`\u0003%IW.\\;uC\ndWM\u0003\u0002au\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\tl&\u0001\u0002'jgR\f!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002\n\u0001d[1gW\u0006\u001cVM\u001d<fe*\u000b\u0017m]#oiJLh*Y7f+\u00051\u0007CA4o\u001d\tAG\u000e\u0005\u0002ju5\t!N\u0003\u0002lU\u00051AH]8pizJ!!\u001c\u001e\u0002\rA\u0013X\rZ3g\u0013\t9vN\u0003\u0002nu\u0005I2.\u00194lCN+'O^3s\u0015\u0006\f7/\u00128ueft\u0015-\\3!\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001t!\t!\u00180D\u0001v\u0015\t1x/\u0001\u0003bkRD'B\u0001=F\u0003!\u0019XmY;sSRL\u0018B\u0001>v\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0002{B!\u0011H`A\u0001\u0013\ty(H\u0001\u0003T_6,\u0007\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dA+\u0001\u0003vi&d\u0017\u0002BA\u0006\u0003\u000b\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003U\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002\nAc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\u0018!F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003/\ti\u0002E\u0002:\u00033I1!a\u0007;\u0005\u0011)f.\u001b;\t\u000f\u0005}\u0001\u00031\u0001\u0002\"\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002$\u0005=RBAA\u0013\u0015\r9\u0013q\u0005\u0006\u0005\u0003S\tY#A\u0004kkBLG/\u001a:\u000b\u0007\u00055\"*A\u0003kk:LG/\u0003\u0003\u00022\u0005\u0015\"\u0001\u0003+fgRLeNZ8)\u0007A\t)\u0004\u0005\u0003\u0002$\u0005]\u0012\u0002BA\u001d\u0003K\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tGCAA\fQ\r\t\u0012\u0011\t\t\u0005\u0003G\t\u0019%\u0003\u0003\u0002F\u0005\u0015\"!C!gi\u0016\u0014X)Y2i\u0003-!Xm\u001d;NKR\u0014\u0018nY:)\u0007I\tY\u0005\u0005\u0003\u0002$\u00055\u0013\u0002BA(\u0003K\u0011A\u0001V3ti\u0006Y1/\u001a8e%\u0016\u001cwN\u001d3t))\t9\"!\u0016\u0002t\u0005]\u00141\u0010\u0005\b\u0003/\u001a\u0002\u0019AA-\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003CA.\u0003G\n9'a\u001a\u000e\u0005\u0005u#\u0002BA,\u0003?R1!!\u0019H\u0003\u001d\u0019G.[3oiNLA!!\u001a\u0002^\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u0004R!OA5\u0003[J1!a\u001b;\u0005\u0015\t%O]1z!\rI\u0014qN\u0005\u0004\u0003cR$\u0001\u0002\"zi\u0016Da!!\u001e\u0014\u0001\u0004A\u0014A\u00038v[J+7m\u001c:eg\"1\u0011\u0011P\nA\u0002a\n!B]3d_J$7+\u001b>f\u0011\u001d\tih\u0005a\u0001\u0003\u007f\n!\u0001\u001e9\u0011\t\u0005\u0005\u00151Q\u0007\u0002\u000b&\u0019\u0011QQ#\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006ir-\u001a8fe\u0006$X-Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\r\u0006\u0003\u0002\u0018\u0005-\u0005bBA?)\u0001\u0007\u0011qP\u0001*m\u0016\u0014\u0018NZ=LC\u001a\\\u0017MU1uK6+GO]5dg\"\u000bg/Z\"v[Vd\u0017\r^5wK\u000e{WO\u001c;\u0015\r\u0005]\u0011\u0011SAJ\u0011\u001d\t9&\u0006a\u0001\u00033Bq!!&\u0016\u0001\u0004\t9*\u0001\u0005d_:\u001cX/\\3s!!\tI*!(\u0002h\u0005\u001dTBAAN\u0015\u0011\t)*a\u0018\n\t\u0005}\u00151\u0014\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u00025Y,'/\u001b4z\u00072LWM\u001c;WKJ\u001c\u0018n\u001c8NKR\u0014\u0018nY:\u0015\r\u0005]\u0011QUAg\u0011\u001d\t9K\u0006a\u0001\u0003S\u000bq!\\3ue&\u001c7\u000f\r\u0003\u0002,\u0006m\u0006\u0003CA\u0002\u0003[\u000b\t,a.\n\t\u0005=\u0016Q\u0001\u0002\u0004\u001b\u0006\u0004\b\u0003BAA\u0003gK1!!.F\u0005)iU\r\u001e:jG:\u000bW.\u001a\t\u0005\u0003s\u000bY\f\u0004\u0001\u0005\u0019\u0005u\u0016QUA\u0001\u0002\u0003\u0015\t!a0\u0003\u0007}#\u0013'\u0005\u0003\u0002B\u0006\u001d\u0007cA\u001d\u0002D&\u0019\u0011Q\u0019\u001e\u0003\u000f9{G\u000f[5oOB!\u0011\u0011QAe\u0013\r\tY-\u0012\u0002\u0007\u001b\u0016$(/[2\t\r\u0005=g\u00031\u0001g\u0003\u0019)g\u000e^5us\u0006\tc/\u001a:jMf\u0014%o\\6fe\u0006+H\u000f[3oi&\u001c\u0017\r^5p]6+GO]5dgR!\u0011qCAk\u0011\u001d\t9n\u0006a\u0001\u00033\faa]3sm\u0016\u0014\b\u0003BAn\u0003?l!!!8\u000b\u0007\u0005]\u0007&\u0003\u0003\u0002b\u0006u'aC&bM.\f7+\u001a:wKJ\fAE^3sS\u001aL(I]8lKJlUm]:bO\u0016\u001cuN\u001c<feNLwN\\'fiJL7m\u001d\u000b\t\u0003/\t9/!;\u0002l\"9\u0011q\u001b\rA\u0002\u0005e\u0007BBA=1\u0001\u0007\u0001\bC\u0004\u0002~a\u0001\r!a \u0002+Y,'/\u001b4z\u0005J|7.\u001a:[W6+GO]5dgR1\u0011qCAy\u0003gDq!a6\u001a\u0001\u0004\tI\u000e\u0003\u0004\u0002vf\u0001\rAZ\u0001\u0006i>\u0004\u0018nY\u0001\u0019m\u0016\u0014\u0018NZ=Ce>\\WM]#se>\u0014X*\u001a;sS\u000e\u001cH\u0003BA\f\u0003wDq!a6\u001b\u0001\u0004\tI.A\twKJLg-_&bM.\fW*\u001a;sS\u000e,BA!\u0001\u0003\bQQ!1\u0001B\u0018\u0005g\u0011yD!\u0011\u0015\t\t\u0015!1\u0003\t\u0005\u0003s\u00139\u0001B\u0004\u0003\nm\u0011\rAa\u0003\u0003\u0003Q\u000bB!!1\u0003\u000eA\u0019\u0011Ha\u0004\n\u0007\tE!HA\u0002B]fDqA!\u0006\u001c\u0001\u0004\u00119\"\u0001\u0004wKJLg-\u001f\t\bs\te!Q\u0004B\u0003\u0013\r\u0011YB\u000f\u0002\n\rVt7\r^5p]F\u0002bAa\b\u0003*\u0005\u001dg\u0002\u0002B\u0011\u0005Kq1!\u001bB\u0012\u0013\u0005Y\u0014b\u0001B\u0014u\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0016\u0005[\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005OQ\u0004B\u0002B\u00197\u0001\u0007a-\u0001\u0003oC6,\u0007bBAT7\u0001\u0007!Q\u0007\u0019\u0005\u0005o\u0011Y\u0004\u0005\u0005\u0002\u0004\u00055\u0016\u0011\u0017B\u001d!\u0011\tILa\u000f\u0005\u0019\tu\"1GA\u0001\u0002\u0003\u0015\t!a0\u0003\u0007}##\u0007\u0003\u0004\u0002Pn\u0001\rA\u001a\u0005\n\u0005\u0007Z\u0002\u0013!a\u0001\u0005\u000b\nQa\u001a:pkB\u0004B!\u000fB$M&\u0019!\u0011\n\u001e\u0003\r=\u0003H/[8o\u0003m1XM]5gs.\u000bgm[1NKR\u0014\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%iU!!q\nB3+\t\u0011\tF\u000b\u0003\u0003F\tM3F\u0001B+!\u0011\u00119F!\u0019\u000e\u0005\te#\u0002\u0002B.\u0005;\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}#(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0019\u0003Z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\t%AD1\u0001\u0003\f\u0005\u0019R.\u0019=LC\u001a\\\u0017-T3ue&\u001cg+\u00197vKRQ!1\u000eB9\u0005g\u0012yH!!\u0011\u0007e\u0012i'C\u0002\u0003pi\u0012a\u0001R8vE2,\u0007B\u0002B\u0019;\u0001\u0007a\rC\u0004\u0002(v\u0001\rA!\u001e1\t\t]$1\u0010\t\t\u0003\u0007\ti+!-\u0003zA!\u0011\u0011\u0018B>\t1\u0011iHa\u001d\u0002\u0002\u0003\u0005)\u0011AA`\u0005\ryFe\r\u0005\u0007\u0003\u001fl\u0002\u0019\u00014\t\u000f\t\rS\u00041\u0001\u0003F\u0005Ib/\u001a:jMf\\\u0015MZ6b\u001b\u0016$(/[2SK\u000e|'\u000fZ3e))\t9Ba\"\u0003\n\nU%q\u0013\u0005\u0007\u0005cq\u0002\u0019\u00014\t\u000f\u0005\u001df\u00041\u0001\u0003\fB\"!Q\u0012BI!!\t\u0019!!,\u00022\n=\u0005\u0003BA]\u0005##ABa%\u0003\n\u0006\u0005\t\u0011!B\u0001\u0003\u007f\u00131a\u0018\u00135\u0011\u0019\tyM\ba\u0001M\"I!1\t\u0010\u0011\u0002\u0003\u0007!QI\u0001$m\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001c'+Z2pe\u0012,G\r\n3fM\u0006,H\u000e\u001e\u00135\u0003EI\u0018-\\7fe6+GO]5d-\u0006dW/\u001a\u000b\u0005\u0005\u001b\u0011y\n\u0003\u0004\u00032\u0001\u0002\rAZ\u0001\u0010s\u0006lW.\u001a:ISN$xn\u001a:b[R!!Q\u0015B^!\u0011\u00119Ka.\u000e\u0005\t%&\u0002\u0002BV\u0005[\u000bAaY8sK*!\u0011q\u0015BX\u0015\u0011\u0011\tLa-\u0002\re\fW.\\3s\u0015\t\u0011),A\u0002d_6LAA!/\u0003*\nI\u0001*[:u_\u001e\u0014\u0018-\u001c\u0005\u0007\u0005c\t\u0003\u0019\u00014\u00025Y,'/\u001b4z3\u0006lW.\u001a:NKR\u0014\u0018n\u0019*fG>\u0014H-\u001a3\u0015\r\t-$\u0011\u0019Bb\u0011\u0019\u0011\tD\ta\u0001M\"I!Q\u0003\u0012\u0011\u0002\u0003\u0007!Q\u0019\t\bs\te!1\u000eBd!\rI$\u0011Z\u0005\u0004\u0005\u0017T$a\u0002\"p_2,\u0017M\\\u0001%m\u0016\u0014\u0018NZ=ZC6lWM]'fiJL7MU3d_J$W\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u001b\u0016\u0005\u0005\u000b\u0014\u0019&\u0001\fwKJLg-\u001f(p%\u0016\fX/Z:u\u001b\u0016$(/[2t)\u0011\t9Ba6\t\r\teG\u00051\u0001g\u00031)'O]8s\u001b\u0016\u001c8/Y4f\u0001")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @Test
    public void testMetrics() {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        Properties prop = new Properties();
        prop.setProperty("enable.idempotence", "false");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, prop);
        this.sendRecords(producer, numRecords, recordSize, tp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, 15000L);
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes)));
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        ByteArraySerializer byteArraySerializer;
        ByteArraySerializer byteArraySerializer2;
        String string;
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", this.kafkaClientSaslMechanism());
        saslProps.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty((String)this.kafkaClientSaslMechanism(), (String)"badUser", (String)"badPass"));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long l = 0x100000L;
        int n = Integer.MAX_VALUE;
        int n2 = 30000;
        int n3 = 0;
        int n4 = 16384;
        String string2 = string = "none";
        string = null;
        String x$13 = string2;
        ByteArraySerializer byteArraySerializer3 = byteArraySerializer2 = new ByteArraySerializer();
        byteArraySerializer2 = null;
        ByteArraySerializer x$14 = byteArraySerializer3;
        ByteArraySerializer byteArraySerializer4 = byteArraySerializer = new ByteArraySerializer();
        byteArraySerializer = null;
        ByteArraySerializer x$15 = byteArraySerializer4;
        boolean bl = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, 0, 1000L, l, n, n2, n3, n4, x$13, 1000, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, bl);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(consumer.metrics().keySet()).asScala().toSet();
        ((IterableOnceOps)consumerMetricNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = CollectionConverters$.MODULE$.SetHasAsScala(producer.metrics().keySet()).asScala().toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableOnceOps)((IterableOps)producerMetricNames.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"commit-id", "version"})).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, name);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed-authentication-total not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assertions.assertTrue((tempBytes >= (double)recordSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString());
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString();
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$1(verifyYammerMetricRecorded_metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name).append(" value ").append(verifyYammerMetricRecorded_metricValue).toString());
        Object var9_7 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name2 = new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString();
        double verifyYammerMetricRecorded_metricValue2 = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name2));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$2(verifyYammerMetricRecorded_metricValue2), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name2).append(" value ").append(verifyYammerMetricRecorded_metricValue2).toString());
        Object var12_9 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((histogram.count() > initialCount ? 1 : 0) != 0, (String)"ZooKeeper latency not recorded");
        double min = histogram.min();
        Assertions.assertTrue((min >= 0.0 ? 1 : 0) != 0, (String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString());
        Assertions.assertEquals((Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"), (String)"Unexpected ZK state");
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assertions.assertEquals((int)(startErrorMetricCount + 1), (int)currentErrorMetricCount);
        Assertions.assertTrue((currentErrorMetricCount < 10 ? 1 : 0) != 0, (String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString());
        try {
            consumer.partitionsFor("non-existing-topic");
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(50).append(errorMetricPrefix).append(",request=Metadata,error=UNKNOWN_TOPIC_OR_PARTITION").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return MetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString());
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Object yammerMetricValue(String name) {
        void var5_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$7 -> x$7.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        Object object = var5_4 instanceof Meter ? BoxesRunTime.boxToDouble((double)((Meter)var5_4).count()) : (var5_4 instanceof Histogram ? BoxesRunTime.boxToDouble((double)((Histogram)var5_4).max()) : (var5_4 instanceof Gauge ? ((Gauge)var5_4).value() : Assertions.fail((String)new StringBuilder(34).append("Unexpected broker metric of class ").append(var5_4.getClass()).toString())));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private Histogram yammerHistogram(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerHistogram$1(name, x0$1))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$8 -> x$8.getMBeanName())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (!(var4_4 instanceof Histogram)) {
            throw new AssertionError((Object)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
        }
        Histogram histogram = (Histogram)var4_4;
        return histogram;
    }

    /*
     * WARNING - void declaration
     */
    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        void var3_3;
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assertions.assertTrue((boolean)verify.apply$mcZD$sp(metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString());
        return (double)var3_3;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assertions.assertTrue((boolean)metrics.isEmpty(), (String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assertions.assertTrue((totalExists || totalTimeExists ? 1 : 0) != 0, (String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString());
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assertions.assertEquals((int)1, (int)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assertions.assertNotNull((Object)value, (String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$1).toString());
        Assertions.assertNotNull((Object)BoxesRunTime.boxToBoolean((value instanceof String && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)value)) ? 1 : 0) != 0), (String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$1).append(" should be a non-empty String").toString());
        Assertions.assertTrue((boolean)metric.metricName().tags().containsKey("client-id"), (String)"Client-id not specified");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        None$ none$;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ verifyKafkaMetric_group = none$2;
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(metrics$1).asScala().filter(arg_0 -> MetricsTest.$anonfun$verifyKafkaMetric$1$adapted(name, (Option)verifyKafkaMetric_group, arg_0));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(MetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$1(double value) {
        return value > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$2(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)))).size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.name();
        boolean bl = !(string != null ? !string.equals(name$2) : name$2 != null) && group$1.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        return bl;
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$4, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$4);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        return bl;
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.kafkaClientSaslMechanism()}));
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }
}

