/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.BaseProducerSendTest;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.BufferExhaustedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005Q4AAC\u0006\u0001!!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C\u00013!)!\n\u0001C\u0001\u0017\")\u0001\u000b\u0001C\u0001#\")a\u000b\u0001C\u0001/\")A\f\u0001C\u0001;\")!\r\u0001C\u0001G\")\u0001\u000e\u0001C\u0001S\")a\u000e\u0001C\u0001_\nI\u0002\u000b\\1j]R,\u0007\u0010\u001e)s_\u0012,8-\u001a:TK:$G+Z:u\u0015\taQ\"A\u0002ba&T\u0011AD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013'5\t1\"\u0003\u0002\u0015\u0017\t!\")Y:f!J|G-^2feN+g\u000e\u001a+fgR\fa\u0001P5oSRtD#A\f\u0011\u0005I\u0001\u0011a\u0005;fgR<&o\u001c8h'\u0016\u0014\u0018.\u00197ju\u0016\u0014HC\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0011)f.\u001b;\t\u000b\u0005\u0012\u0001\u0019\u0001\u0012\u0002\rE,xN];n!\t\u0019#F\u0004\u0002%QA\u0011Q\u0005H\u0007\u0002M)\u0011qeD\u0001\u0007yI|w\u000e\u001e \n\u0005%b\u0012A\u0002)sK\u0012,g-\u0003\u0002,Y\t11\u000b\u001e:j]\u001eT!!\u000b\u000f)\t\tqC(\u0010\t\u0003_ij\u0011\u0001\r\u0006\u0003cI\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003gQ\na\u0001]1sC6\u001c(BA\u001b7\u0003\u001dQW\u000f]5uKJT!a\u000e\u001d\u0002\u000b),h.\u001b;\u000b\u0003e\n1a\u001c:h\u0013\tY\u0004GA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0003}\u0001\u000b\u0013aP\u0001\u0003u.\f\u0013!Q\u0001\u0006WJ\fg\r\u001e\u0015\u0005\u0005\r;\u0005\n\u0005\u0002E\u000b6\t!'\u0003\u0002Ge\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002\u0013\u0006A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002#Q,7\u000f\u001e\"bi\u000eD7+\u001b>f5\u0016\u0014x\u000e\u0006\u0002\u001b\u0019\")\u0011e\u0001a\u0001E!\"1A\f\u001fOY\tq\u0004\t\u000b\u0003\u0004\u0007\u001eC\u0015A\u000b;fgR\u001cVM\u001c3D_6\u0004(/Z:tK\u0012lUm]:bO\u0016<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u000b\u00035ICQ!\t\u0003A\u0002\tBC\u0001\u0002\u0018=)2\u0012a\b\u0011\u0015\u0005\t\r;\u0005*A\u0017uKN$8+\u001a8e\u001d>t7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3XSRDGj\\4BaB,g\u000e\u001a+j[\u0016$\"A\u0007-\t\u000b\u0005*\u0001\u0019\u0001\u0012)\t\u0015qCH\u0017\u0017\u0003}\u0001CC!B\"H\u0011\u0006\u0019B/Z:u\u0003V$xn\u0011:fCR,Gk\u001c9jGR\u0011!D\u0018\u0005\u0006C\u0019\u0001\rA\t\u0015\u0005\r9b\u0004\r\f\u0002?\u0001\"\"aaQ$I\u0003u!Xm\u001d;TK:$w+\u001b;i\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,GC\u0001\u000ee\u0011\u0015\ts\u00011\u0001#Q\u00119a\u0006\u00104-\u0005y\u0002\u0005\u0006B\u0004D\u000f\"\u000bq\u0003^3ti:{gN\u00117pG.Lgn\u001a)s_\u0012,8-\u001a:\u0015\u0005iQ\u0007\"B\u0011\t\u0001\u0004\u0011\u0003\u0006\u0002\u0005/y1d#A\u0010!)\t!\u0019u\tS\u0001/i\u0016\u001cHoU3oIJ+7m\u001c:e\u0005\u0006$8\r[,ji\"l\u0015\r\u001f*fcV,7\u000f^*ju\u0016\fe\u000e\u001a%jO\",'\u000f\u0006\u0002\u001ba\")\u0011%\u0003a\u0001E!\"\u0011B\f\u001fsY\tq\u0004\t\u000b\u0003\n\u0007\u001eC\u0005")
public class PlaintextProducerSendTest
extends BaseProducerSendTest {
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWrongSerializer(String quorum) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(SerializationException.class, () -> producer.send(record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBatchSizeZero(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerify(producer, this.sendAndVerify$default$2(), this.sendAndVerify$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendCompressedMessageWithLogAppendTime(String quorum) {
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, x$4, "gzip", x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendNonCompressedMessageWithLogAppendTime(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoCreateTopic(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record).get()).offset(), (String)"Should have offset 0");
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic(), 0, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendWithInvalidCreateTime(String quorum) {
        Map map;
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), "1000");
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Map map2 = map = (Map)Map$.MODULE$.empty();
        map = null;
        Map x$7 = map2;
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, 1, 2, (Map<Object, Seq<Object>>)x$7, topicProps);
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(System.currentTimeMillis() - 1001L), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
        int x$9 = this.createProducer$default$1();
        int x$10 = this.createProducer$default$2();
        int x$11 = this.createProducer$default$3();
        long x$12 = this.createProducer$default$5();
        long x$13 = this.createProducer$default$6();
        try (KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$9, x$10, x$11, "gzip", x$12, x$13);){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(System.currentTimeMillis() - 1001L), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNonBlockingProducer(String quorum) {
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$5, 0L, x$6);
        PlaintextProducerSendTest.verifyMetadataNotAvailable$1(this.send$1(producer));
        Future future = this.sendUntilQueued$1(producer);
        this.verifySendSuccess$1(future);
        int x$11 = this.createProducer$default$2();
        String x$12 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer2 = this.createProducer(15000, x$11, 1100, x$12, 0L, 1500L);
        Future future2 = this.sendUntilQueued$1(producer2);
        PlaintextProducerSendTest.verifyBufferExhausted$1(this.send$1(producer2));
        this.verifySendSuccess$1(future2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendRecordBatchWithMaxRequestSizeAndHigher(String quorum) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()));
        int keyLengthSize = 1;
        int headerLengthSize = 1;
        int valueLengthSize = 3;
        int overhead = 94 + keyLengthSize + headerLengthSize + valueLengthSize;
        int valueSize = Defaults$.MODULE$.MessageMaxBytes() - overhead;
        ProducerRecord record0 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize]);
        Assertions.assertEquals((int)((byte[])record0.value()).length, (int)((RecordMetadata)producer.send(record0).get()).serializedValueSize());
        ProducerRecord record1 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize + 1]);
        Assertions.assertEquals(RecordTooLargeException.class, Assertions.assertThrows(ExecutionException.class, () -> producer.send(record1).get()).getCause().getClass());
    }

    private final Future send$1(KafkaProducer producer) {
        return producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)new byte[1000]));
    }

    public static final /* synthetic */ boolean $anonfun$testNonBlockingProducer$2(Future future) {
        if (future.isDone()) {
            try {
                future.get();
                return true;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Future sendUntilQueued$1(KafkaProducer producer) {
        void var3_8;
        Tuple2 tuple2;
        long l = 15000L;
        long l2 = 100L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Future computeUntilTrue_result;
            if (PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(computeUntilTrue_result = this.send$1(producer))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + l) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Tuple2 tuple22 = tuple2;
        Object var6_5 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Future future = (Future)tuple23._1();
        return var3_8;
    }

    private final void verifySendSuccess$1(Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get(30L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)0, (int)recordMetadata.partition());
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
    }

    private static final void verifyMetadataNotAvailable$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    private static final void verifyBufferExhausted$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(BufferExhaustedException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    public static final /* synthetic */ Object $anonfun$testNonBlockingProducer$2$adapted(Future future) {
        return BoxesRunTime.boxToBoolean((boolean)PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(future));
    }
}

