/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001A\u0002\u0013\u00051\u0006C\u00040\u0001\u0001\u0007I\u0011\u0001\u0019\t\rY\u0002\u0001\u0015)\u0003-\u0011\u001d9\u0004A1A\u0005\u0002aBa\u0001\u0010\u0001!\u0002\u0013I\u0004bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0011B \t\u000b\r\u0003A\u0011\u0001#\t\u000bI\u0003A\u0011\u0001#\t\u000b]\u0003A\u0011\u0001#\t\u000bq\u0003A\u0011\u0001#\t\u000by\u0003A\u0011\u0001#\t\u000b\u0001\u0004A\u0011\u0001#\t\u000b\t\u0004A\u0011\u0001#\t\u000b\u0011\u0004A\u0011\u0001#\t\u000b\u0019\u0004A\u0011\u0001#\t\u000b!\u0004A\u0011\u0001#\t\u000b)\u0004A\u0011\u0001#\t\u000b1\u0004A\u0011\u0001#\t\u000b9\u0004A\u0011\u0001#\t\u000bA\u0004A\u0011A9\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011q\b\u0001\u0005\u0002\u0005\u0005#aD(gMN,G/\u00138eKb$Vm\u001d;\u000b\u0005ma\u0012a\u00017pO*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u00025\u0005\u0019\u0011\u000e\u001a=\u0016\u00031\u0002\"!K\u0017\n\u00059R\"aC(gMN,G/\u00138eKb\fq!\u001b3y?\u0012*\u0017\u000f\u0006\u00022iA\u0011\u0011EM\u0005\u0003g\t\u0012A!\u00168ji\"9QgAA\u0001\u0002\u0004a\u0013a\u0001=%c\u0005!\u0011\u000e\u001a=!\u0003)i\u0017\r_#oiJLWm]\u000b\u0002sA\u0011\u0011EO\u0005\u0003w\t\u00121!\u00138u\u0003-i\u0017\r_#oiJLWm\u001d\u0011\u0002\u0015\t\f7/Z(gMN,G/F\u0001@!\t\t\u0003)\u0003\u0002BE\t!Aj\u001c8h\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\u0002\u000bM,G/\u001e9\u0015\u0003EB#!\u0003$\u0011\u0005\u001d\u0003V\"\u0001%\u000b\u0005%S\u0015aA1qS*\u00111\nT\u0001\bUV\u0004\u0018\u000e^3s\u0015\tie*A\u0003kk:LGOC\u0001P\u0003\ry'oZ\u0005\u0003#\"\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^t\u0007F\u0001\u0006U!\t9U+\u0003\u0002W\u0011\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0011e\u0006tGm\\7M_>\\W\u000f\u001d+fgRD#aC-\u0011\u0005\u001dS\u0016BA.I\u0005\u0011!Vm\u001d;\u0002%1|wn[;q\u000bb$(/Z7f\u0007\u0006\u001cXm\u001d\u0015\u0003\u0019e\u000b\u0011\u0002^3ti\u0016sGO]=)\u00055I\u0016!\u0005;fgR,e\u000e\u001e:z\u001fZ,'O\u001a7po\"\u0012a\"W\u0001\u000eCB\u0004XM\u001c3U_>l\u0015M\\=)\u0005=I\u0016\u0001E1qa\u0016tGmT;u\u001f\u001a|%\u000fZ3sQ\t\u0001\u0012,A\ruKN$h)\u001a;dQV\u0003\b/\u001a:C_VtGm\u00144gg\u0016$\bFA\tZ\u0003)!Xm\u001d;SK>\u0004XM\u001c\u0015\u0003%e\u000b\u0001\u0002\u001e:v]\u000e\fG/\u001a\u0015\u0003'e\u000baBZ8sG\u0016,f.\\1q)\u0016\u001cH\u000f\u000b\u0002\u00153\u0006)C/Z:u'\u0006t\u0017\u000e^=MCN$xJ\u001a4tKR,\u0015/^1m)>\u0014\u0015m]3PM\u001a\u001cX\r\u001e\u0015\u0003+e\u000b\u0001#Y:tKJ$xK]5uK\u001a\u000b\u0017\u000e\\:\u0016\u0007I\f)\u0002\u0006\u00052g\u0006\u0005\u00111AA\u0004\u0011\u0015!h\u00031\u0001v\u0003\u001diWm]:bO\u0016\u0004\"A^?\u000f\u0005]\\\bC\u0001=#\u001b\u0005I(B\u0001>\u001f\u0003\u0019a$o\\8u}%\u0011API\u0001\u0007!J,G-\u001a4\n\u0005y|(AB*ue&twM\u0003\u0002}E!)!F\u0006a\u0001Y!1\u0011Q\u0001\fA\u0002e\naa\u001c4gg\u0016$\bbBA\u0005-\u0001\u0007\u00111B\u0001\u0006W2\f7o\u001d\t\u0006m\u00065\u0011\u0011C\u0005\u0004\u0003\u001fy(!B\"mCN\u001c\b\u0003BA\n\u0003+a\u0001\u0001B\u0004\u0002\u0018Y\u0011\r!!\u0007\u0003\u0003Q\u000bB!a\u0007\u0002\"A\u0019\u0011%!\b\n\u0007\u0005}!EA\u0004O_RD\u0017N\\4\u0011\u0007\u0005\n\u0019#C\u0002\u0002&\t\u00121!\u00118z\u00031iwN\\8u_:L7mU3r)\u0019\tY#a\u000e\u0002<A)\u0011QFA\u001as5\u0011\u0011q\u0006\u0006\u0004\u0003c\u0011\u0013AC2pY2,7\r^5p]&!\u0011QGA\u0018\u0005\r\u0019V-\u001d\u0005\u0007\u0003s9\u0002\u0019A\u001d\u0002\t\t\f7/\u001a\u0005\u0007\u0003{9\u0002\u0019A\u001d\u0002\u00071,g.A\no_:,\u00050[:uK:$H+Z7q\r&dW\r\u0006\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013AA5p\u0015\t\ti%\u0001\u0003kCZ\f\u0017\u0002BA)\u0003\u000f\u0012AAR5mK\u0002")
public class OffsetIndexTest {
    private OffsetIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @BeforeEach
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240, true));
    }

    @AfterEach
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L), (String)"Not present value should return physical offset 0.");
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableOps)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable)x$1 -> x$1)).zip(this.monotonicSeq(0, size));
        vals.foreach((Function1 & Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$2 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$2);
            return BoxedUnit.UNIT;
        });
        TreeMap valMap = (TreeMap)new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((IterableOnce)vals.map((Function1 & Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p)));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray((ClassTag)ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList(new long[][]{offsets}));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.longArrayOps(offsets), 30)), (Function1)(JFunction1.mcVJ.sp & Serializable)offset -> Assertions.assertEquals((Object)(offset < BoxesRunTime.unboxToLong((Object)valMap.firstKey()) ? new OffsetPosition(this.idx().baseOffset(), 0) : new OffsetPosition(((TreeMap)valMap.to((Object)BoxesRunTime.boxToLong((long)offset))).last()._1$mcJ$sp(), ((Tuple2)((TreeMap)valMap.to((Object)BoxesRunTime.boxToLong((long)offset))).last()._2())._2$mcI$sp())), (Object)this.idx().lookup(offset), (String)"The index should give the same answer as the sorted map"));
    }

    @Test
    public void lookupExtremeCases() {
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()), (String)"Lookup on empty file");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void testEntry() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)i + 1L, i), (Object)this.idx().entry(i)));
    }

    @Test
    public void testEntryOverflow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.idx().entry(0));
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            long offset = this.idx().baseOffset() + (long)i + 1L;
            this.idx().append(offset, i);
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        Assertions.assertThrows(InvalidOffsetException.class, () -> this.idx().append(50L, 1));
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 5));
        new .colon.colon((Object)first, (List)new .colon.colon((Object)second, (List)new .colon.colon((Object)third, (List)new .colon.colon((Object)fourth, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)offsetPosition -> {
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assertions.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assertions.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assertions.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assertions.assertEquals((Object)new Some((Object)fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), -1, true);
        Assertions.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assertions.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assertions.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assertions.assertEquals((int)2, (int)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, true);
        idx.truncate();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> idx.append((long)i, i));
        idx.truncateTo(12L);
        Assertions.assertEquals((Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L), (String)"Index should be unchanged by truncate past the end");
        Assertions.assertEquals((long)9L, (long)idx.lastOffset(), (String)"9 should be the last entry in the index");
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assertions.assertEquals((Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L), (String)"Index should be unchanged by truncate at the end");
        Assertions.assertEquals((long)9L, (long)idx.lastOffset(), (String)"9 should be the last entry in the index");
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assertions.assertEquals((Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L), (String)"Index should truncate off last entry");
        Assertions.assertEquals((long)8L, (long)idx.lastOffset(), (String)"8 should be the last entry in the index");
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assertions.assertEquals((Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L), (String)"4 should be the last entry in the index");
        Assertions.assertEquals((long)4L, (long)idx.lastOffset(), (String)"4 should be the last entry in the index");
        idx.append(5L, 5);
        idx.truncate();
        Assertions.assertEquals((int)0, (int)idx.entries(), (String)"Full truncation should leave no entries");
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, true);
        idx.forceUnmap();
        Assertions.assertThrows(NullPointerException.class, () -> idx.lookup(1L));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80, true);
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> idx.append((long)offset, 1), () -> message);
        Assertions.assertEquals(klass, e.getClass(), (String)"Got an unexpected exception.");
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable)x$3 -> OffsetIndexTest.$anonfun$monotonicSeq$1(last, rand, vals, BoxesRunTime.unboxToInt((Object)x$3)));
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistentTempFile() {
        void var1_1;
        File file = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Files.delete(file.toPath());
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$2) {
        if (x$2 != null) {
            long logical = x$2._1$mcJ$sp();
            int physical = x$2._2$mcI$sp();
            Assertions.assertEquals((Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical), (String)"Should be able to find values that are present.");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset(), offsetPosition.position());
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(IntRef last$1, Random rand$1, ArrayBuffer vals$1, int x$3) {
        last$1.elem += rand$1.nextInt(15) + 1;
        return (ArrayBuffer)vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)last$1.elem));
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

