/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001B\r\u001b\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00043\u0001\u0001\u0006IA\f\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019Y\u0004\u0001)A\u0005k!9A\b\u0001b\u0001\n\u0013i\u0004B\u0002&\u0001A\u0003%a\bC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rQ\u0003\u0001\u0015!\u0003N\u0011\u001d)\u0006A1A\u0005\nYCaa\u0017\u0001!\u0002\u00139\u0006\"\u0003/\u0001\u0001\u0004\u0005\r\u0011\"\u0003^\u0011%\t\u0007\u00011AA\u0002\u0013%!\rC\u0005i\u0001\u0001\u0007\t\u0011)Q\u0005=\"I\u0011\u000e\u0001a\u0001\u0002\u0004%IA\u001b\u0005\ns\u0002\u0001\r\u00111A\u0005\niD\u0011\u0002 \u0001A\u0002\u0003\u0005\u000b\u0015B6\t\u000bu\u0004A\u0011\u0001@\t\r\u0005U\u0001\u0001\"\u0001\u007f\u0011\u0019\ty\u0002\u0001C\u0001}\"1\u00111\u0005\u0001\u0005\u0002yDa!a\n\u0001\t\u0003q\bbBA\u0019\u0001\u0011%\u00111\u0007\u0005\b\u0003W\u0002A\u0011BA7\u0005eyeMZ:fiN4uN\u001d'fC\u0012,'/\u00129pG\"$Vm\u001d;\u000b\u0005ma\u0012!B3q_\u000eD'BA\u000f\u001f\u0003\u0019\u0019XM\u001d<fe*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u00025\u000511m\u001c8gS\u001e,\u0012A\f\t\u0003_Aj\u0011\u0001H\u0005\u0003cq\u00111bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u000e\t\u0003mej\u0011a\u000e\u0006\u0003qy\tQ!\u001e;jYNL!AO\u001c\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq!\\3ue&\u001c7/F\u0001?!\ty\u0004*D\u0001A\u0015\ta\u0014I\u0003\u0002C\u0007\u000611m\\7n_:T!a\b#\u000b\u0005\u00153\u0015AB1qC\u000eDWMC\u0001H\u0003\ry'oZ\u0005\u0003\u0013\u0002\u0013q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003=\tG\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014X#A'\u0011\u00059\u000bfB\u0001\u001cP\u0013\t\u0001v'A\u0005UKN$X\u000b^5mg&\u0011!k\u0015\u0002\u001a\u001b>\u001c7.\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'O\u0003\u0002Qo\u0005\u0001\u0012\r\u001c;fe&\u001b(/T1oC\u001e,'\u000fI\u0001\u0003iB,\u0012a\u0016\t\u00031fk\u0011!Q\u0005\u00035\u0006\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0002ua\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001_!\tys,\u0003\u0002a9\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$\"a\u00194\u0011\u0005\r\"\u0017BA3%\u0005\u0011)f.\u001b;\t\u000f\u001dl\u0011\u0011!a\u0001=\u0006\u0019\u0001\u0010J\u0019\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\nA\"];pi\u0006l\u0015M\\1hKJ,\u0012a\u001b\t\u0003YZt!!\u001c;\u000f\u00059\u001chBA8s\u001b\u0005\u0001(BA9!\u0003\u0019a$o\\8u}%\tq$\u0003\u0002\u001e=%\u0011Q\u000fH\u0001\r#V|G/\u0019$bGR|'/_\u0005\u0003ob\u0014Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(BA;\u001d\u0003A\tXo\u001c;b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002dw\"9q\rEA\u0001\u0002\u0004Y\u0017!D9v_R\fW*\u00198bO\u0016\u0014\b%A\u0003tKR,\u0006\u000fF\u0001dQ\r\u0011\u0012\u0011\u0001\t\u0005\u0003\u0007\t\t\"\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u0017\ti!A\u0004kkBLG/\u001a:\u000b\u0007\u0005=a)A\u0003kk:LG/\u0003\u0003\u0002\u0014\u0005\u0015!A\u0003\"fM>\u0014X-R1dQ\u0006Q2\u000f[8vY\u0012<U\r^#q_\u000eD7O\u0012:p[J+\u0007\u000f\\5dC\"\u001a1#!\u0007\u0011\t\u0005\r\u00111D\u0005\u0005\u0003;\t)A\u0001\u0003UKN$\u0018\u0001K:i_VdGMU3ukJtgj\u001c'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:Le\r\u00165s_^t\u0007f\u0001\u000b\u0002\u001a\u0005Y3\u000f[8vY\u0012\u0014V\r^;s]Vs7N\\8x]R{\u0007/[2PeB\u000b'\u000f^5uS>t\u0017J\u001a+ie><h\u000eK\u0002\u0016\u00033\t\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004-\u0005-\u0002\u0003BA\u0002\u0003[IA!a\f\u0002\u0006\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0018]\u0016<xJ\u001a4tKR4uN\u001d'fC\u0012,'\u000fV8qS\u000e$\u0002\"!\u000e\u0002\\\u0005u\u0013q\r\t\u0005\u0003o\t)F\u0004\u0003\u0002:\u0005=c\u0002BA\u001e\u0003\u0017rA!!\u0010\u0002J9!\u0011qHA$\u001d\u0011\t\t%!\u0012\u000f\u0007=\f\u0019%C\u0001H\u0013\t)e)\u0003\u0002 \t&\u0011!iQ\u0005\u0004\u0003\u001b\n\u0015aB7fgN\fw-Z\u0005\u0005\u0003#\n\u0019&A\u0010PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f\u001e#bi\u0006T1!!\u0014B\u0013\u0011\t9&!\u0017\u0003)=3gm]3u\r>\u0014H*Z1eKJ$v\u000e]5d\u0015\u0011\t\t&a\u0015\t\u000bU;\u0002\u0019A,\t\u000f\u0005}s\u00031\u0001\u0002b\u0005\u00112-\u001e:sK:$H*Z1eKJ,\u0005o\\2i!\r\u0019\u00131M\u0005\u0004\u0003K\"#aA%oi\"9\u0011\u0011N\fA\u0002\u0005\u0005\u0014a\u00037fC\u0012,'/\u00129pG\"\fQD\\3x\u001f\u001a47/\u001a;G_JdU-\u00193feR{\u0007/[2SKN,H\u000e\u001e\u000b\u000b\u0003_\ni(a \u0002\u0010\u0006E\u0005\u0003BA9\u0003orA!!\u000f\u0002t%!\u0011QOA*\u0003\u0001zeMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005e\u00141\u0010\u0002\u001b\u001f\u001a47/\u001a;G_JdU-\u00193feR{\u0007/[2SKN,H\u000e\u001e\u0006\u0005\u0003k\n\u0019\u0006C\u0003V1\u0001\u0007q\u000bC\u0004\u0002\u0002b\u0001\r!a!\u0002\u000b\u0015\u0014(o\u001c:\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#B\u0003!\u0001(o\u001c;pG>d\u0017\u0002BAG\u0003\u000f\u0013a!\u0012:s_J\u001c\bbBA51\u0001\u0007\u0011\u0011\r\u0005\b\u0003'C\u0002\u0019AAK\u0003%)g\u000eZ(gMN,G\u000fE\u0002$\u0003/K1!!'%\u0005\u0011auN\\4")
public class OffsetsForLeaderEpochTest {
    private final KafkaConfig config = (KafkaConfig)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(1, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props))).head();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final TestUtils.MockAlterPartitionManager alterIsrManager = new TestUtils.MockAlterPartitionManager();
    private final TopicPartition tp = new TopicPartition("topic", 1);
    private ReplicaManager replicaManager;
    private QuotaFactory.QuotaManagers quotaManager;

    private KafkaConfig config() {
        return this.config;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private TestUtils.MockAlterPartitionManager alterIsrManager() {
        return this.alterIsrManager;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    private QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    private void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), ""));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldGetEpochsFromReplica() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        AtomicBoolean atomicBoolean;
        BrokerTopicStats brokerTopicStats;
        void zkMetadataCache_brokerFeatures;
        void zkMetadataCache_metadataVersion;
        ZkMetadataCache zkMetadataCache;
        BrokerFeatures brokerFeatures;
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(42L, 5);
        int epochRequested = 5;
        scala.collection.immutable.Seq request = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic[]{this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested)}));
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)mockLog.endOffsetForEpoch(epochRequested)).thenReturn((Object)new Some((Object)offsetAndEpoch));
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = this.config();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        BrokerFeatures brokerFeatures2 = brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        brokerFeatures = null;
        BrokerFeatures brokerFeatures3 = brokerFeatures2;
        MetadataVersion metadataVersion = this.config().interBrokerProtocolVersion();
        int zkMetadataCache_brokerId = this.config().brokerId();
        ZkMetadataCache zkMetadataCache2 = zkMetadataCache = new ZkMetadataCache(zkMetadataCache_brokerId, (MetadataVersion)zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures);
        metadataVersion = null;
        brokerFeatures3 = null;
        zkMetadataCache = null;
        ZkMetadataCache x$7 = zkMetadataCache2;
        LogDirFailureChannel x$8 = new LogDirFailureChannel(this.config().logDirs().size());
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = new BrokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$10 = brokerTopicStats2;
        AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
        atomicBoolean = null;
        AtomicBoolean x$11 = atomicBoolean2;
        None$ none$7 = none$6 = None$.MODULE$;
        none$6 = null;
        None$ x$12 = none$7;
        None$ none$8 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$13 = none$8;
        None$ none$9 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$14 = none$9;
        None$ none$10 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$15 = none$10;
        None$ none$11 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$16 = none$11;
        None$ none$12 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$17 = none$12;
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, x$6, (MetadataCache)x$7, x$8, (AlterPartitionManager)x$9, x$10, x$11, (Option)x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17));
        Partition partition = this.replicaManager().createPartition(this.tp());
        partition.setLog(mockLog, false);
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)this.config().brokerId())));
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult[]{this.newOffsetForLeaderTopicResult(this.tp(), Errors.NONE, offsetAndEpoch.leaderEpoch(), offsetAndEpoch.offset())})), (Object)response);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReturnNoLeaderForPartitionIfThrown() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        AtomicBoolean atomicBoolean;
        BrokerTopicStats brokerTopicStats;
        void zkMetadataCache_brokerFeatures;
        void zkMetadataCache_metadataVersion;
        ZkMetadataCache zkMetadataCache;
        BrokerFeatures brokerFeatures;
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = this.config();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        BrokerFeatures brokerFeatures2 = brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        brokerFeatures = null;
        BrokerFeatures brokerFeatures3 = brokerFeatures2;
        MetadataVersion metadataVersion = this.config().interBrokerProtocolVersion();
        int zkMetadataCache_brokerId = this.config().brokerId();
        ZkMetadataCache zkMetadataCache2 = zkMetadataCache = new ZkMetadataCache(zkMetadataCache_brokerId, (MetadataVersion)zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures);
        metadataVersion = null;
        brokerFeatures3 = null;
        zkMetadataCache = null;
        ZkMetadataCache x$7 = zkMetadataCache2;
        LogDirFailureChannel x$8 = new LogDirFailureChannel(this.config().logDirs().size());
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = new BrokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$10 = brokerTopicStats2;
        AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
        atomicBoolean = null;
        AtomicBoolean x$11 = atomicBoolean2;
        None$ none$7 = none$6 = None$.MODULE$;
        none$6 = null;
        None$ x$12 = none$7;
        None$ none$8 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$13 = none$8;
        None$ none$9 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$14 = none$9;
        None$ none$10 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$15 = none$10;
        None$ none$11 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$16 = none$11;
        None$ none$12 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$17 = none$12;
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, x$6, (MetadataCache)x$7, x$8, (AlterPartitionManager)x$9, x$10, x$11, (Option)x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17));
        this.replicaManager().createPartition(this.tp());
        int epochRequested = 5;
        scala.collection.immutable.Seq request = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic[]{this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested)}));
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult[]{this.newOffsetForLeaderTopicResult(this.tp(), Errors.NOT_LEADER_OR_FOLLOWER, -1, -1L)})), (Object)response);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReturnUnknownTopicOrPartitionIfThrown() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        AtomicBoolean atomicBoolean;
        BrokerTopicStats brokerTopicStats;
        void zkMetadataCache_brokerFeatures;
        void zkMetadataCache_metadataVersion;
        ZkMetadataCache zkMetadataCache;
        BrokerFeatures brokerFeatures;
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = this.config();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        BrokerFeatures brokerFeatures2 = brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        brokerFeatures = null;
        BrokerFeatures brokerFeatures3 = brokerFeatures2;
        MetadataVersion metadataVersion = this.config().interBrokerProtocolVersion();
        int zkMetadataCache_brokerId = this.config().brokerId();
        ZkMetadataCache zkMetadataCache2 = zkMetadataCache = new ZkMetadataCache(zkMetadataCache_brokerId, (MetadataVersion)zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures);
        metadataVersion = null;
        brokerFeatures3 = null;
        zkMetadataCache = null;
        ZkMetadataCache x$7 = zkMetadataCache2;
        LogDirFailureChannel x$8 = new LogDirFailureChannel(this.config().logDirs().size());
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = new BrokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$10 = brokerTopicStats2;
        AtomicBoolean atomicBoolean2 = atomicBoolean = new AtomicBoolean(false);
        atomicBoolean = null;
        AtomicBoolean x$11 = atomicBoolean2;
        None$ none$7 = none$6 = None$.MODULE$;
        none$6 = null;
        None$ x$12 = none$7;
        None$ none$8 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$13 = none$8;
        None$ none$9 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$14 = none$9;
        None$ none$10 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$15 = none$10;
        None$ none$11 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$16 = none$11;
        None$ none$12 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$17 = none$12;
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, x$6, (MetadataCache)x$7, x$8, (AlterPartitionManager)x$9, x$10, x$11, (Option)x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17));
        int epochRequested = 5;
        scala.collection.immutable.Seq request = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic[]{this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested)}));
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult[]{this.newOffsetForLeaderTopicResult(this.tp(), Errors.UNKNOWN_TOPIC_OR_PARTITION, -1, -1L)})), (Object)response);
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    private OffsetForLeaderEpochRequestData.OffsetForLeaderTopic newOffsetForLeaderTopic(TopicPartition tp, int currentLeaderEpoch, int leaderEpoch) {
        return new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition[]{new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(tp.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setLeaderEpoch(leaderEpoch)}))).asJava());
    }

    private OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult newOffsetForLeaderTopicResult(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        return new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetForLeaderEpochResponseData.EpochEndOffset[]{new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset)}))).asJava());
    }
}

