/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.ProducerState;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.errors.TransactionalIdNotFoundException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.opentest4j.AssertionFailedError;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\u0019\u0005\u0001)A\u0005{!9A\t\u0001b\u0001\n\u0003a\u0004BB#\u0001A\u0003%Q\bC\u0004G\u0001\t\u0007I\u0011A$\t\rM\u0003\u0001\u0015!\u0003I\u0011\u001d!\u0006A1A\u0005\u0002UCa\u0001\u0018\u0001!\u0002\u00131\u0006\"C/\u0001\u0001\u0004\u0005\r\u0011\"\u0001_\u0011%a\u0007\u00011AA\u0002\u0013\u0005Q\u000eC\u0005t\u0001\u0001\u0007\t\u0011)Q\u0005?\"IA\u000f\u0001a\u0001\u0002\u0004%\t!\u001e\u0005\nw\u0002\u0001\r\u00111A\u0005\u0002qD\u0011B \u0001A\u0002\u0003\u0005\u000b\u0015\u0002<\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0003\t\t\u0001C\u0006\u0002\u000e\u0001\u0001\r\u00111A\u0005\u0002\u0005=\u0001bCA\n\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0007Aq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007Dq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002r\u0002!I!!\u0016\t\u000f\u0005M\b\u0001\"\u0003\u0002v\nA\u0002K]8ek\u000e,'/\u00133FqBL'/\u0019;j_:$Vm\u001d;\u000b\u0005\u0005\u0012\u0013aA1qS*\t1%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#BA\u0015#\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005-B#AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005q\u0003CA\u0018\u0001\u001b\u0005\u0001\u0013A\u0002;pa&\u001c\u0017'F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0003mC:<'\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u0012aa\u0015;sS:<\u0017a\u0002;pa&\u001c\u0017\u0007I\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u00121!\u00138u\u00039qW/\u001c)beRLG/[8og\u0002\n\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0003I\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011\u0002\u0007Q\u0004\b'F\u0001I!\tI\u0015+D\u0001K\u0015\tYE*\u0001\u0004d_6lwN\u001c\u0006\u0003G5S!AT(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0016aA8sO&\u0011!K\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0011!\b\u000f\r\u0011\u0002\u001d\r|gNZ5h%\u0016\u001cx.\u001e:dKV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z\u0015\u000611m\u001c8gS\u001eL!a\u0017-\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\u0006y1m\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0007%\u0001\u0005qe>$WoY3s+\u0005y\u0006\u0003\u00021eM\u001al\u0011!\u0019\u0006\u0003;\nT!a\u0019'\u0002\u000f\rd\u0017.\u001a8ug&\u0011Q-\u0019\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u0007y:\u0017.\u0003\u0002i\u007f\t)\u0011I\u001d:bsB\u0011aH[\u0005\u0003W~\u0012AAQ=uK\u0006a\u0001O]8ek\u000e,'o\u0018\u0013fcR\u0011a.\u001d\t\u0003}=L!\u0001] \u0003\tUs\u0017\u000e\u001e\u0005\be6\t\t\u00111\u0001`\u0003\rAH%M\u0001\naJ|G-^2fe\u0002\n\u0001bY8ogVlWM]\u000b\u0002mB!q/\u001f4g\u001b\u0005A(B\u0001;c\u0013\tQ\bP\u0001\u0005D_:\u001cX/\\3s\u00031\u0019wN\\:v[\u0016\u0014x\fJ3r)\tqW\u0010C\u0004s!\u0005\u0005\t\u0019\u0001<\u0002\u0013\r|gn];nKJ\u0004\u0013!B1e[&tWCAA\u0002!\u0011\t)!!\u0003\u000e\u0005\u0005\u001d!BA@c\u0013\u0011\tY!a\u0002\u0003\u000b\u0005#W.\u001b8\u0002\u0013\u0005$W.\u001b8`I\u0015\fHc\u00018\u0002\u0012!A!oEA\u0001\u0002\u0004\t\u0019!\u0001\u0004bI6Lg\u000eI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\u0011\u0011\u0011\u0004\t\u0007\u00037\t\t#!\n\u000e\u0005\u0005u!bAA\u0010\u007f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0012Q\u0004\u0002\u0004'\u0016\f\b\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-\"%\u0001\u0004tKJ4XM]\u0005\u0005\u0003_\tICA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!B:fiV\u0003Hc\u00018\u00026!9\u0011q\u0007\fA\u0002\u0005e\u0012\u0001\u0003;fgRLeNZ8\u0011\t\u0005m\u0012qI\u0007\u0003\u0003{Q1!IA \u0015\u0011\t\t%a\u0011\u0002\u000f),\b/\u001b;fe*\u0019\u0011QI(\u0002\u000b),h.\u001b;\n\t\u0005%\u0013Q\b\u0002\t)\u0016\u001cH/\u00138g_\"\u001aa#!\u0014\u0011\t\u0005m\u0012qJ\u0005\u0005\u0003#\niD\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002]\"\u001aq#!\u0017\u0011\t\u0005m\u00121L\u0005\u0005\u0003;\niDA\u0005BMR,'/R1dQ\u0006QC/Z:u!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8XSRDgj\u001c+sC:\u001c\u0018m\u0019;j_:\u001cHc\u00018\u0002d!9\u0011Q\r\rA\u0002\u0005\u001d\u0014AB9v_J,X\u000e\u0005\u0003\u0002j\u0005]d\u0002BA6\u0003g\u00022!!\u001c@\u001b\t\tyGC\u0002\u0002r\u0011\na\u0001\u0010:p_Rt\u0014bAA;\u007f\u00051\u0001K]3eK\u001aL1!OA=\u0015\r\t)h\u0010\u0015\b1\u0005u\u0014\u0011RAF!\u0011\ty(!\"\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u007f\ta\u0001]1sC6\u001c\u0018\u0002BAD\u0003\u0003\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u00055\u0015AI>eSN\u0004H.Y=OC6,WPL>be\u001e,X.\u001a8ug^KG\u000f\u001b(b[\u0016\u001cX\u0010K\u0004\u0019\u0003#\u000bi*a(\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+SA!a&\u0002\u0002\u0006A\u0001O]8wS\u0012,'/\u0003\u0003\u0002\u001c\u0006U%a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u0002\"\u0006\u0015\u0016EAAR\u0003\tQ8.\t\u0002\u0002(\u0006)1N]1gi\u0006aD/Z:u)J\fgn]1di&|g.\u00114uKJ$&/\u00198tC\u000e$\u0018n\u001c8JI\u0016C\b/\u001b:fg\n+H\u000f\u0015:pIV\u001cWM]%e%\u0016l\u0017-\u001b8t)\rq\u0017Q\u0016\u0005\b\u0003KJ\u0002\u0019AA4Q\u001dI\u0012QPAE\u0003\u0017Cs!GAI\u0003;\u000b\u0019\f\f\u0003\u0002\"\u0006\u0015\u0016!\t;fgR$\u0015P\\1nS\u000e\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]6\u001bHc\u00018\u0002:\"9\u0011Q\r\u000eA\u0002\u0005\u001d\u0004f\u0002\u000e\u0002~\u0005%\u00151\u0012\u0015\b5\u0005E\u0015QTA`Y\u0011\t\t+!*\u0002\u001bA\u0014x\u000eZ;dKJ\u001cF/\u0019;f+\t\t)\r\u0005\u0004\u0002H\u00065\u0017\u0011[\u0007\u0003\u0003\u0013T1!a37\u0003\u0011)H/\u001b7\n\t\u0005=\u0017\u0011\u001a\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0006\u0005M\u0017\u0002BAk\u0003\u000f\u0011Q\u0002\u0015:pIV\u001cWM]*uCR,\u0017A\u00079s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|gnQ8oM&<G\u0003BAn\u0003[\u0004r!a2\u0002^Z\u000b\t/\u0003\u0003\u0002`\u0006%'aA'baB1\u0011qYAr\u0003OLA!!:\u0002J\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\t\u0005\u0015\u0011\u0011^\u0005\u0005\u0003W\f9AA\u0007BYR,'oQ8oM&<w\n\u001d\u0005\b\u0003_d\u0002\u0019AA4\u0003-\u0019wN\u001c4jOZ\u000bG.^3\u0002E]\f\u0017\u000e^+oi&dGK]1og\u0006\u001cG/[8oC2\u001cF/\u0019;f\u000bb\u0004\u0018N]3t\u0003-\u0019XM\u001d<feB\u0013x\u000e]:\u0015\u0005\u0005]\b\u0003BAd\u0003sLA!a?\u0002J\nQ\u0001K]8qKJ$\u0018.Z:")
public class ProducerIdExpirationTest
extends KafkaServerTestHarness {
    private final String topic1;
    private final int numPartitions;
    private final int replicationFactor;
    private final TopicPartition tp0 = new TopicPartition(this.topic1(), 0);
    private final ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
    private KafkaProducer<byte[], byte[]> producer;
    private Consumer<byte[], byte[]> consumer;
    private Admin admin;

    public String topic1() {
        return this.topic1;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public ConfigResource configResource() {
        return this.configResource;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(Consumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$4 -> {
            Properties fromProps_overrides = this.serverProps();
            return KafkaConfig$.MODULE$.fromProps(x$4, fromProps_overrides, true);
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$4 = "group";
        String x$5 = "earliest";
        int x$6 = 500;
        SecurityProtocol x$7 = SecurityProtocol.PLAINTEXT;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        ByteArrayDeserializer x$10 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$4, x$5, false, true, x$6, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11));
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties()));
        this.createTopic(this.topic1(), this.numPartitions(), 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        if (this.consumer() != null) {
            this.consumer().close();
        }
        if (this.admin() != null) {
            this.admin().close();
        }
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testProducerIdExpirationWithNoTransactions(String quorum) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        int x$3 = -1;
        long x$4 = 60000L;
        long x$5 = 0x100000L;
        int x$6 = Integer.MAX_VALUE;
        int x$7 = 30000;
        int x$8 = 0;
        int x$9 = 16384;
        String x$10 = "none";
        int x$11 = 20000;
        SecurityProtocol x$12 = SecurityProtocol.PLAINTEXT;
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        ByteArraySerializer x$15 = new ByteArraySerializer();
        ByteArraySerializer x$16 = new ByteArraySerializer();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Option<File>)x$13, (Option<Properties>)x$14, x$15, x$16, true));
        this.producer().send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes()));
        this.producer().flush();
        this.ensureConsistentKRaftMetadata();
        Assertions.assertEquals((int)1, (int)this.producerState().size());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testProducerIdExpirationWithNoTransactions$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Producer ID did not expire.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.producer().send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes()));
        this.producer().flush();
        Assertions.assertEquals((int)1, (int)this.producerState().size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTransactionAfterTransactionIdExpiresButProducerIdRemains(String quorum) {
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", this.brokers(), 16384, 60000L, 60000L, 120000, 30000, 5));
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "2", "2", false));
        this.producer().flush();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Producer IDs were not added.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.producer().abortTransaction();
        this.waitUntilTransactionalStateExpires();
        Assertions.assertEquals((int)1, (int)this.producerState().size());
        this.producer().beginTransaction();
        Future failedFuture = this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "1", "1", false));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!failedFuture.isDone()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Producer future never completed.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        TestUtils.assertFutureThrows((Future)failedFuture, InvalidPidMappingException.class);
        this.producer().abortTransaction();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "3", "3", true));
        Assertions.assertEquals((int)1, (int)this.producerState().size());
        this.producer().commitTransaction();
        this.consumer().subscribe(Collections.singletonList(this.topic1()));
        TestUtils$.MODULE$.consumeRecords(this.consumer(), 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicProducerIdExpirationMs(String quorum) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        int x$3 = -1;
        long x$4 = 60000L;
        long x$5 = 0x100000L;
        int x$6 = Integer.MAX_VALUE;
        int x$7 = 30000;
        int x$8 = 0;
        int x$9 = 16384;
        String x$10 = "none";
        int x$11 = 20000;
        SecurityProtocol x$12 = SecurityProtocol.PLAINTEXT;
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        ByteArraySerializer x$15 = new ByteArraySerializer();
        ByteArraySerializer x$16 = new ByteArraySerializer();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Option<File>)x$13, (Option<Properties>)x$14, x$15, x$16, true));
        this.producer().send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes()));
        this.producer().flush();
        this.ensureConsistentKRaftMetadata();
        Assertions.assertEquals((int)1, (int)this.producerState().size());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Producer ID did not expire.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.admin().incrementalAlterConfigs(this.producerIdExpirationConfig("100000"));
        this.brokers().foreach((Function1 & Serializable)broker -> {
            ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$3(broker);
            return BoxedUnit.UNIT;
        });
        this.producer().send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes()));
        this.producer().flush();
        Assertions.assertEquals((int)1, (int)this.producerState().size());
        Assertions.assertThrows(AssertionFailedError.class, () -> {
            long waitUntilTrue_pause = 100L;
            long waitUntilTrue_waitTimeMs = 4000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$7(this)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Producer ID did not expire.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
            }
        });
        this.admin().incrementalAlterConfigs(this.producerIdExpirationConfig("100")).all().get();
        this.killBroker(0);
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.brokers().foreach((Function1 & Serializable)broker -> {
            ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$9(broker);
            return BoxedUnit.UNIT;
        });
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$12(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Producer ID did not expire.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    private List<ProducerState> producerState() {
        return ((DescribeProducersResult.PartitionProducerState)this.admin().describeProducers(Collections.singletonList(this.tp0())).partitionResult(this.tp0()).get()).activeProducers();
    }

    private java.util.Map<ConfigResource, Collection<AlterConfigOp>> producerIdExpirationConfig(String configValue) {
        ConfigEntry producerIdCfg = new ConfigEntry(KafkaConfig$.MODULE$.ProducerIdExpirationMsProp(), configValue);
        List<AlterConfigOp> configs = Collections.singletonList(new AlterConfigOp(producerIdCfg, AlterConfigOp.OpType.SET));
        return Collections.singletonMap(this.configResource(), configs);
    }

    private void waitUntilTransactionalStateExpires() {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$waitUntilTransactionalStateExpires$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Transaction state never expired.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    private Properties serverProps() {
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(3));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        serverProps.put(KafkaConfig$.MODULE$.TransactionalIdExpirationMsProp(), "5000");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsRemoveExpiredTransactionalIdCleanupIntervalMsProp(), "500");
        serverProps.put(KafkaConfig$.MODULE$.ProducerIdExpirationMsProp(), "10000");
        serverProps.put(KafkaConfig$.MODULE$.ProducerIdExpirationCheckIntervalMsProp(), "500");
        return serverProps;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerIdExpirationWithNoTransactions$1(ProducerIdExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testProducerIdExpirationWithNoTransactions$2() {
        return "Producer ID did not expire.";
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$1(ProducerIdExpirationTest $this) {
        return $this.producerState().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$2() {
        return "Producer IDs were not added.";
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$3(Future failedFuture$1) {
        return failedFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterTransactionIdExpiresButProducerIdRemains$4() {
        return "Producer future never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicProducerIdExpirationMs$1(ProducerIdExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDynamicProducerIdExpirationMs$2() {
        return "Producer ID did not expire.";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicProducerIdExpirationMs$4(KafkaBroker broker$1) {
        return broker$1.logManager().producerStateManagerConfig().producerIdExpirationMs() == 100000;
    }

    public static final /* synthetic */ String $anonfun$testDynamicProducerIdExpirationMs$5() {
        return "Configuration was not updated.";
    }

    public static final /* synthetic */ void $anonfun$testDynamicProducerIdExpirationMs$3(KafkaBroker broker) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$4(broker)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Configuration was not updated.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicProducerIdExpirationMs$7(ProducerIdExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDynamicProducerIdExpirationMs$8() {
        return "Producer ID did not expire.";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicProducerIdExpirationMs$10(KafkaBroker broker$2) {
        return broker$2.logManager().producerStateManagerConfig().producerIdExpirationMs() == 100;
    }

    public static final /* synthetic */ String $anonfun$testDynamicProducerIdExpirationMs$11() {
        return "Configuration was not updated.";
    }

    public static final /* synthetic */ void $anonfun$testDynamicProducerIdExpirationMs$9(KafkaBroker broker) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdExpirationTest.$anonfun$testDynamicProducerIdExpirationMs$10(broker)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Configuration was not updated.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicProducerIdExpirationMs$12(ProducerIdExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDynamicProducerIdExpirationMs$13() {
        return "Producer ID did not expire.";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTransactionalStateExpires$1(ProducerIdExpirationTest $this) {
        boolean removedTransactionState = false;
        try {
            $this.admin().describeTransactions(Collections.singletonList("transactionalProducer")).description("transactionalProducer").get();
        }
        catch (Exception exception) {
            removedTransactionState = exception.getCause() instanceof TransactionalIdNotFoundException;
        }
        return removedTransactionState;
    }

    public static final /* synthetic */ String $anonfun$waitUntilTransactionalStateExpires$2() {
        return "Transaction state never expired.";
    }

    public ProducerIdExpirationTest() {
        this.topic1 = "topic1";
        this.numPartitions = 1;
        this.replicationFactor = 3;
    }
}

