/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collections;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.log.TxnIndexSearchResult;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005e4A!\u0006\f\u00017!)!\u0005\u0001C\u0001G!Ia\u0005\u0001a\u0001\u0002\u0004%\ta\n\u0005\na\u0001\u0001\r\u00111A\u0005\u0002EB\u0011b\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0015\t\u0013a\u0002\u0001\u0019!a\u0001\n\u0003I\u0004\"\u0003%\u0001\u0001\u0004\u0005\r\u0011\"\u0001J\u0011%Y\u0005\u00011A\u0001B\u0003&!\bC\u0004M\u0001\t\u0007I\u0011A'\t\rE\u0003\u0001\u0015!\u0003O\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015y\u0006\u0001\"\u0001T\u0011\u0015!\u0007\u0001\"\u0001T\u0011\u0015I\u0007\u0001\"\u0001T\u0011\u0015Y\u0007\u0001\"\u0001T\u0011\u0015i\u0007\u0001\"\u0001T\u0011\u0015y\u0007\u0001\"\u0001T\u0011\u0015\t\b\u0001\"\u0001T\u0011\u0015\u0019\b\u0001\"\u0001T\u0011\u0015)\b\u0001\"\u0001T\u0011\u00159\b\u0001\"\u0001T\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010V3ti*\u0011q\u0003G\u0001\u0004Y><'\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u00051\u0012\u0001\u00024jY\u0016,\u0012\u0001\u000b\t\u0003S9j\u0011A\u000b\u0006\u0003W1\n!![8\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u0005\r&dW-\u0001\u0005gS2,w\fJ3r)\t\u0011T\u0007\u0005\u0002\u001eg%\u0011AG\b\u0002\u0005+:LG\u000fC\u00047\u0007\u0005\u0005\t\u0019\u0001\u0015\u0002\u0007a$\u0013'A\u0003gS2,\u0007%A\u0003j]\u0012,\u00070F\u0001;!\tYd)D\u0001=\u0015\t9RH\u0003\u0002?\u007f\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003\u0001\u0006\u000bqa\u001d;pe\u0006<WM\u0003\u0002\u001a\u0005*\u00111\tR\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\u000b1a\u001c:h\u0013\t9EH\u0001\tUe\u0006t7/Y2uS>t\u0017J\u001c3fq\u0006I\u0011N\u001c3fq~#S-\u001d\u000b\u0003e)CqA\u000e\u0004\u0002\u0002\u0003\u0007!(\u0001\u0004j]\u0012,\u0007\u0010I\u0001\u0007_\u001a47/\u001a;\u0016\u00039\u0003\"!H(\n\u0005As\"\u0001\u0002'p]\u001e\fqa\u001c4gg\u0016$\b%A\u0003tKR,\b\u000fF\u00013Q\tQQ\u000b\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006\u0019\u0011\r]5\u000b\u0005i[\u0016a\u00026va&$XM\u001d\u0006\u00039\u0012\u000bQA[;oSRL!AX,\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hm\\<oQ\tY\u0011\r\u0005\u0002WE&\u00111m\u0016\u0002\n\u0003\u001a$XM]#bG\"\f!\u0005^3tiB{7/\u001b;j_:\u001cV\r^\"peJ,7\r\u001e7z/\",gn\u00149f]\u0016$\u0007F\u0001\u0007g!\t1v-\u0003\u0002i/\n!A+Z:u\u0003=!Xm\u001d;TC:LG/_\"iK\u000e\\\u0007FA\u0007g\u0003i!Xm\u001d;MCN$xJ\u001a4tKRlUo\u001d;J]\u000e\u0014X-Y:fQ\tqa-\u0001\u000fuKN$H*Y:u\u001f\u001a47/\u001a;DC:tw\u000e\u001e#fGJ,\u0017m]3)\u0005=1\u0017A\b;fgR\u001cu\u000e\u001c7fGR\f%m\u001c:uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8tQ\t\u0001b-\u0001\u0007uKN$HK];oG\u0006$X\r\u000b\u0002\u0012M\u0006\u0019B/Z:u\u0003\n|'\u000f^3e)bt7+\u001a:eK\"\u0012!CZ\u0001\u0010i\u0016\u001cHOU3oC6,\u0017J\u001c3fq\"\u00121CZ\u0001\u0014i\u0016\u001cH/\u00169eCR,\u0007+\u0019:f]R$\u0015N\u001d\u0015\u0003)\u0019\u0004")
public class TransactionIndexTest {
    private File file;
    private TransactionIndex index;
    private final long offset;

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    @BeforeEach
    public void setup() {
        this.file_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
        this.index_$eq(new TransactionIndex(this.offset(), this.file()));
    }

    @AfterEach
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        .colon.colon abortedTxns = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTxns.foreach(arg_0 -> TransactionIndexTest.$anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(this.index(), arg_0));
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file());
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTxns.$plus$plus((IterableOnce)new .colon.colon((Object)anotherAbortedTxn, (List)Nil$.MODULE$))).asJava(), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test
    public void testSanityCheck() {
        new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$)))).foreach(arg_0 -> TransactionIndexTest.$anonfun$testSanityCheck$1$adapted(this.index(), arg_0));
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(100L, this.file());
        Assertions.assertThrows(CorruptIndexException.class, () -> reopenedIndex.sanityCheck());
    }

    @Test
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index().append(new AbortedTxn(0L, 0L, 15L, 11L)));
    }

    @Test
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index().append(new AbortedTxn(0L, 0L, 10L, 11L)));
    }

    @Test
    public void testCollectAbortedTransactions() {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTransactions.foreach(arg_0 -> TransactionIndexTest.$anonfun$testCollectAbortedTransactions$1$adapted(this.index(), arg_0));
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)result.abortedTransactions);
        Assertions.assertFalse((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(0L, 32L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.take(3)).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(0L, 35L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(10L, 35L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(11L, 35L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.slice(1, 4)).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(20L, 41L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.slice(2, 4)).asJava(), (Object)result.abortedTransactions);
        Assertions.assertFalse((boolean)result.isComplete);
    }

    @Test
    public void testTruncate() {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 2L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 16L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTransactions.foreach(arg_0 -> TransactionIndexTest.$anonfun$testTruncate$1$adapted(this.index(), arg_0));
        this.index().truncateTo(51L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)this.index().collectAbortedTxns((long)0L, (long)100L).abortedTransactions);
        this.index().truncateTo(50L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.take(3)).asJava(), (Object)this.index().collectAbortedTxns((long)0L, (long)100L).abortedTransactions);
        this.index().reset();
        Assertions.assertEquals(Collections.emptyList(), (Object)this.index().collectAbortedTxns((long)0L, (long)100L).abortedTransactions);
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assertions.assertEquals((short)0, (short)abortedTxn.version());
        Assertions.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File renamed = TestUtils.tempFile((String)"kafka", (String)".tmp");
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        java.util.List abortedTxns = this.index().collectAbortedTxns((long)0L, (long)100L).abortedTransactions;
        Assertions.assertEquals((int)2, (int)abortedTxns.size());
        Assertions.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.get(0)).firstOffset());
        Assertions.assertEquals((long)5L, (long)((AbortedTxn)abortedTxns.get(1)).firstOffset());
    }

    @Test
    public void testUpdateParentDir() {
        File tmpParentDir = new File(TestUtils.tempDirectory(null, null), "parent");
        tmpParentDir.mkdir();
        Assertions.assertNotEquals((Object)tmpParentDir, (Object)this.index().file().getParentFile());
        this.index().updateParentDir(tmpParentDir);
        Assertions.assertEquals((Object)tmpParentDir, (Object)this.index().file().getParentFile());
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }

    public static final /* synthetic */ Object $anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(TransactionIndex eta$0$1$1, AbortedTxn x$1) {
        eta$0$1$1.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSanityCheck$1$adapted(TransactionIndex eta$0$1$2, AbortedTxn x$1) {
        eta$0$1$2.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCollectAbortedTransactions$1$adapted(TransactionIndex eta$0$1$3, AbortedTxn x$1) {
        eta$0$1$3.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncate$1$adapted(TransactionIndex eta$0$1$4, AbortedTxn x$1) {
        eta$0$1$4.append(x$1);
        return BoxedUnit.UNIT;
    }
}

