/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tud\u0001\u0002\u0017.\u0001IBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001C\u0002\u0013\u0005A\t\u0003\u0004R\u0001\u0001\u0006I!\u0012\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0011\u0019Q\u0006\u0001)A\u0005)\"91\f\u0001b\u0001\n\u0003a\u0006BB3\u0001A\u0003%Q\fC\u0004g\u0001\t\u0007I\u0011A4\t\r-\u0004\u0001\u0015!\u0003i\u0011\u001da\u0007A1A\u0005\u00025Da\u0001\u001e\u0001!\u0002\u0013q\u0007\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0001w\u0011%Q\b\u00011AA\u0002\u0013\u00051\u0010\u0003\u0006\u0002\u0004\u0001\u0001\r\u0011!Q!\n]D1\"!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\b!Y\u0011q\u0002\u0001A\u0002\u0003\u0007I\u0011AA\t\u0011-\t)\u0002\u0001a\u0001\u0002\u0003\u0006K!!\u0003\t\u0017\u0005]\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011\u0004\u0005\f\u0003o\u0001\u0001\u0019!a\u0001\n\u0003\tI\u0004C\u0006\u0002>\u0001\u0001\r\u0011!Q!\n\u0005m\u0001bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u00033\u0002A\u0011AA!\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003\u0003Bq!!\u001c\u0001\t\u0003\t\t\u0005C\u0004\u0002r\u0001!\t!!\u0011\t\u000f\u0005U\u0004\u0001\"\u0001\u0002B\u00191\u0011\u0011\u0010\u0001\u0005\u0003wBaaP\u000e\u0005\u0002\u0005}\u0004\"CAN7\u0001\u0007I\u0011BAO\u0011%\t)k\u0007a\u0001\n\u0013\t9\u000b\u0003\u0005\u0002,n\u0001\u000b\u0015BAP\u0011%\tik\u0007a\u0001\n\u0013\ty\u000bC\u0005\u0002:n\u0001\r\u0011\"\u0003\u0002<\"A\u0011qX\u000e!B\u0013\t\t\fC\u0004\u0002Bn!\t!a1\t\u000f\u0005-7\u0004\"\u0001\u0002N\"9\u0011\u0011[\u000e\u0005\u0002\u0005M\u0007bBAl\u0001\u0011%\u0011\u0011\u001c\u0005\b\u0003c\u0004A\u0011BAz\u0011%\u0011\t\u0006AI\u0001\n\u0013\u0011\u0019\u0006C\u0005\u0003j\u0001\t\n\u0011\"\u0003\u0003l!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002B\u0011\u0001\u0011%!1\u0010\u0002\u0018\u0019>\u001c\u0017\r\u001c'fC\u0012,'/\u00128e!>Lg\u000e\u001e+fgRT!AL\u0018\u0002\rM,'O^3s\u0015\u0005\u0001\u0014!B6bM.\f7\u0001A\n\u0004\u0001MJ\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$AB!osJ+g\r\u0005\u0002;{5\t1H\u0003\u0002=_\u0005)Q\u000f^5mg&\u0011ah\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\t\u0005\u0002C\u00015\tQ&\u0001\u0003uS6,W#A#\u0011\u0005\u0019{U\"A$\u000b\u0005!K\u0015\u0001B;uS2T!A\f&\u000b\u0005AZ%B\u0001'N\u0003\u0019\t\u0007/Y2iK*\ta*A\u0002pe\u001eL!\u0001U$\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq\u0001^8qS\u000eLE-F\u0001U!\t)\u0006,D\u0001W\u0015\t9&*\u0001\u0004d_6lwN\\\u0005\u00033Z\u0013A!V;jI\u0006AAo\u001c9jG&#\u0007%A\u0003u_BL7-F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0003mC:<'\"\u00012\u0002\t)\fg/Y\u0005\u0003I~\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003!\u0004\"!V5\n\u0005)4&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005a1o\\;sG\u0016\u0014%o\\6feV\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002r_\u000591\r\\;ti\u0016\u0014\u0018BA:q\u00059\u0011%o\\6fe\u0016sG\rU8j]R\fQb]8ve\u000e,'I]8lKJ\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002oB\u0011!\t_\u0005\u0003s6\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\nsKBd\u0017nY1NC:\fw-\u001a:`I\u0015\fHC\u0001?\u0000!\t!T0\u0003\u0002\u007fk\t!QK\\5u\u0011!\t\t!DA\u0001\u0002\u00049\u0018a\u0001=%c\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0005f]\u0012\u0004v.\u001b8u+\t\tI\u0001E\u0002C\u0003\u0017I1!!\u0004.\u00059aU-\u00193fe\u0016sG\rU8j]R\fA\"\u001a8e!>Lg\u000e^0%KF$2\u0001`A\n\u0011%\t\t\u0001EA\u0001\u0002\u0004\tI!A\u0005f]\u0012\u0004v.\u001b8uA\u0005a\u0011/^8uC6\u000bg.Y4feV\u0011\u00111\u0004\t\u0005\u0003;\t\tD\u0004\u0003\u0002 \u00055b\u0002BA\u0011\u0003WqA!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O\t\u0014A\u0002\u001fs_>$h(C\u00011\u0013\tqs&C\u0002\u000205\nA\"U;pi\u00064\u0015m\u0019;pefLA!a\r\u00026\ti\u0011+^8uC6\u000bg.Y4feNT1!a\f.\u0003A\tXo\u001c;b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002}\u0003wA\u0011\"!\u0001\u0014\u0003\u0003\u0005\r!a\u0007\u0002\u001bE,x\u000e^1NC:\fw-\u001a:!\u0003\u0015\u0019X\r^+q)\u0005a\bfA\u000b\u0002FA!\u0011qIA+\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013aA1qS*!\u0011qJA)\u0003\u001dQW\u000f]5uKJT1!a\u0015N\u0003\u0015QWO\\5u\u0013\u0011\t9&!\u0013\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r1\u0012Q\f\t\u0005\u0003\u000f\ny&\u0003\u0003\u0002b\u0005%#!C!gi\u0016\u0014X)Y2i\u0003U!Xm\u001d;GKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKRD3aFA4!\u0011\t9%!\u001b\n\t\u0005-\u0014\u0011\n\u0002\u0005)\u0016\u001cH/A\fuKN$h)\u001a;dQ\u0016\u000b'\u000f\\5fgR|eMZ:fi\"\u001a\u0001$a\u001a\u00029Q,7\u000f\u001e$fi\u000eDW)\u0019:mS\u0016\u001cH\u000fT8dC2|eMZ:fi\"\u001a\u0011$a\u001a\u00021Q,7\u000f\u001e$fi\u000eDW\t]8dQ\u0016sGm\u00144gg\u0016$8\u000fK\u0002\u001b\u0003O\u0012abQ1mY\n\f7m\u001b*fgVdG/\u0006\u0003\u0002~\u0005%5CA\u000e4)\t\t\t\tE\u0003\u0002\u0004n\t))D\u0001\u0001!\u0011\t9)!#\r\u0001\u00119\u00111R\u000eC\u0002\u00055%!\u0001+\u0012\t\u0005=\u0015Q\u0013\t\u0004i\u0005E\u0015bAAJk\t9aj\u001c;iS:<\u0007c\u0001\u001b\u0002\u0018&\u0019\u0011\u0011T\u001b\u0003\u0007\u0005s\u00170A\u0003wC2,X-\u0006\u0002\u0002 B)A'!)\u0002\u0006&\u0019\u00111U\u001b\u0003\r=\u0003H/[8o\u0003%1\u0018\r\\;f?\u0012*\u0017\u000fF\u0002}\u0003SC\u0011\"!\u0001\u001f\u0003\u0003\u0005\r!a(\u0002\rY\fG.^3!\u0003\r1WO\\\u000b\u0003\u0003c\u0003R\u0001NAQ\u0003g\u0003b\u0001NA[\u0003\u000bc\u0018bAA\\k\tIa)\u001e8di&|g.M\u0001\bMVtw\fJ3r)\ra\u0018Q\u0018\u0005\n\u0003\u0003\t\u0013\u0011!a\u0001\u0003c\u000bAAZ;oA\u0005A\u0001.Y:GSJ,G-\u0006\u0002\u0002FB\u0019A'a2\n\u0007\u0005%WGA\u0004C_>dW-\u00198\u0002\t\u0019L'/\u001a\u000b\u0004y\u0006=\u0007bBANI\u0001\u0007\u0011QQ\u0001\u0007_:4\u0015N]3\u0015\t\u0005\u0005\u0015Q\u001b\u0005\b\u0003[+\u0003\u0019AAZ\u0003a\u0011W/\u001b7e\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f\u001e\u000b\u0005\u00037\f9\u000f\u0005\u0003\u0002^\u0006\rXBAAp\u0015\r\t\tOV\u0001\te\u0016\fX/Z:ug&!\u0011Q]Ap\u0005MaU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u\u0011\u001d\tIO\na\u0001\u0003W\f1\u0002\\3bI\u0016\u0014X\t]8dQB\u0019A'!<\n\u0007\u0005=XGA\u0002J]R\fQ\"\u00199qK:$'+Z2pe\u0012\u001cH\u0003DA{\u00053\u0011YBa\b\u00030\t\u001d\u0003#BAB7\u0005]\b\u0003BA}\u0005'qA!a?\u0003\u00109!\u0011Q B\u0007\u001d\u0011\tyPa\u0003\u000f\t\t\u0005!\u0011\u0002\b\u0005\u0005\u0007\u00119A\u0004\u0003\u0002$\t\u0015\u0011\"\u0001(\n\u00051k\u0015B\u0001\u0019L\u0013\t9&*C\u0002\u0002bZKAA!\u0005\u0002`\u0006y\u0001K]8ek\u000e,'+Z:q_:\u001cX-\u0003\u0003\u0003\u0016\t]!!\u0005)beRLG/[8o%\u0016\u001c\bo\u001c8tK*!!\u0011CAp\u0011\u0015)x\u00051\u0001x\u0011\u0019\u0011ib\na\u0001Q\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0005C9\u0003\u0019\u0001B\u0012\u0003\u001d\u0011XmY8sIN\u0004BA!\n\u0003,5\u0011!q\u0005\u0006\u0004\u0005S1\u0016A\u0002:fG>\u0014H-\u0003\u0003\u0003.\t\u001d\"!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0005\u00032\u001d\u0002\n\u00111\u0001\u00034\u00051qN]5hS:\u0004BA!\u000e\u0003D5\u0011!q\u0007\u0006\u0005\u0005s\u0011Y$A\u0002m_\u001eTAA!\u0010\u0003@\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0005\u0003R\u0015aB:u_J\fw-Z\u0005\u0005\u0005\u000b\u00129D\u0001\u0007BaB,g\u000eZ(sS\u001eLg\u000eC\u0005\u0003J\u001d\u0002\n\u00111\u0001\u0003L\u0005a!/Z9vSJ,G-Q2lgB\u0019AG!\u0014\n\u0007\t=SGA\u0003TQ>\u0014H/A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u000b\u0016\u0005\u0005g\u00119f\u000b\u0002\u0003ZA!!1\fB3\u001b\t\u0011iF\u0003\u0003\u0003`\t\u0005\u0014!C;oG\",7m[3e\u0015\r\u0011\u0019'N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B4\u0005;\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\t\u0007\u000f]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$S'\u0006\u0002\u0003n)\"!1\nB,\u0003\u0011qw\u000eZ3\u0015\t\tM$\u0011\u0010\t\u0004+\nU\u0014b\u0001B<-\n!aj\u001c3f\u0011\u0019\t)A\u000ba\u0001]V\u0011!1\u0005")
public class LocalLeaderEndPointTest
implements Logging {
    private final MockTime time = new MockTime();
    private final Uuid topicId = Uuid.randomUuid();
    private final String topic;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), 5);
    private final BrokerEndPoint sourceBroker = new BrokerEndPoint(0, "localhost", 9092);
    private ReplicaManager replicaManager;
    private LeaderEndPoint endPoint;
    private QuotaFactory.QuotaManagers quotaManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topic;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LeaderEndPoint endPoint() {
        return this.endPoint;
    }

    public void endPoint_$eq(LeaderEndPoint x$1) {
        this.endPoint = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        void zkMetadataCache_zkMigrationEnabled;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        void zkMetadataCache_metadataVersion;
        int x$1 = this.sourceBroker().id();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = this.sourceBroker().port();
        boolean x$42 = true;
        boolean x$52 = true;
        None$ x$62 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var52_11 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var53_14 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var54_17 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$42, x$52, x$3, (Option<SecurityProtocol>)x$62, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable)x$4 -> new File((String)x$4))), TestUtils$.MODULE$.createLogManager$default$2(), new MockConfigRepository(), new CleanerConfig(false), new MockTime(), MetadataVersion.latestTesting(), 4, false, (Option<UnifiedLog>)None$.MODULE$, false);
        AlterPartitionManager alterPartitionManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        Metrics metrics = new Metrics();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate(config, metrics, (Time)this.time(), ""));
        MockTime x$24 = this.time();
        MockScheduler x$25 = new MockScheduler((Time)this.time());
        QuotaFactory.QuotaManagers x$27 = this.quotaManager();
        boolean bl = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion metadataVersion = config.interBrokerProtocolVersion();
        int zkMetadataCache_brokerId = config.brokerId();
        metadataVersion = null;
        brokerFeatures = null;
        seq = null;
        ZkMetadataCache x$28 = new ZkMetadataCache(zkMetadataCache_brokerId, (MetadataVersion)zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_zkMigrationEnabled);
        LogDirFailureChannel x$29 = new LogDirFailureChannel(config.logDirs().size());
        None$ x$31 = None$.MODULE$;
        BrokerTopicStats x$32 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        AtomicBoolean x$33 = new AtomicBoolean(false);
        None$ x$34 = None$.MODULE$;
        None$ x$35 = None$.MODULE$;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        None$ x$38 = None$.MODULE$;
        None$ x$39 = None$.MODULE$;
        None$ x$40 = None$.MODULE$;
        Function0 x$41 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        None$ x$422 = None$.MODULE$;
        DirectoryEventHandler x$43 = DirectoryEventHandler.NOOP;
        this.replicaManager_$eq(new ReplicaManager(config, metrics, (Time)x$24, (Scheduler)x$25, mockLogMgr, (Option)x$31, x$27, (MetadataCache)x$28, x$29, alterPartitionManager, x$32, x$33, (Option)x$34, (Option)x$35, (Option)x$36, (Option)x$37, (Option)x$38, (Option)x$39, (Option)x$40, x$41, (Option)x$422, x$43));
        Partition partition = this.replicaManager().createPartition(this.topicPartition());
        partition.createLogIfNotExists(false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(this.replicaManager().highWatermarkCheckpoints()), (Option)None$.MODULE$, partition.createLogIfNotExists$default$5());
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(0);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$5, x$6) -> {
            LocalLeaderEndPointTest.$anonfun$setUp$2(x$5, x$6);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().getPartitionOrException(this.topicPartition()).localLogOrException();
        this.endPoint_$eq((LeaderEndPoint)new LocalLeaderEndPoint(this.sourceBroker(), config, this.replicaManager(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$));
    }

    @AfterEach
    public void tearDown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.replicaManager().shutdown(false), (Logging)this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.quotaManager().shutdown(), (Logging)this, Level.WARN);
    }

    @Test
    public void testFetchLatestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 0), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$7, x$8) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$2(x$7, x$8);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$3(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(6L, 4), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$9, x$10) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$2(x$9, x$10);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$3(response);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().deleteRecords(1000L, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)3L))})), (Function1 & Serializable)x$11 -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$4(x$11);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 4), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestLocalOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$12, x$13) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$2(x$12, x$13);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$3(response);
            return BoxedUnit.UNIT;
        });
        LogManager qual$1 = this.replicaManager().logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        qual$1.getLog(x$1, x$2).foreach((Function1 & Serializable)log -> {
            log._localLogStartOffset_$eq(3L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 4), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEpochEndOffsets() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$1(response);
            return BoxedUnit.UNIT;
        });
        Map result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$14, x$15) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$2(x$14, x$15);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$3(response);
            return BoxedUnit.UNIT;
        });
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(4))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(6L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(3))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(5))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(-1).setEndOffset(-1L))}))), (Object)result);
    }

    private LeaderAndIsrRequest buildLeaderAndIsrRequest(int leaderEpoch) {
        java.util.List brokerList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.sourceBroker().id()), (List)Nil$.MODULE$)).asJava();
        java.util.Map<String, Uuid> topicIds = Collections.singletonMap(this.topic(), this.topicId());
        return (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, 0L, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(this.topicPartition().partition()).setControllerEpoch(0).setLeader(this.sourceBroker().id()).setLeaderEpoch(leaderEpoch).setIsr(brokerList).setPartitionEpoch(0).setReplicas(brokerList).setIsNew(false), (List)Nil$.MODULE$)).asJava(), topicIds, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.node(this.sourceBroker())}))).asJava()).build();
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, AppendOrigin origin, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, origin, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable)responses -> {
            LocalLeaderEndPointTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8(), replicaManager.appendRecords$default$9(), replicaManager.appendRecords$default$10(), replicaManager.appendRecords$default$11());
        return result;
    }

    private AppendOrigin appendRecords$default$4() {
        return AppendOrigin.CLIENT;
    }

    private short appendRecords$default$5() {
        return -1;
    }

    private Node node(BrokerEndPoint endPoint) {
        return new Node(endPoint.id(), endPoint.host(), endPoint.port());
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records() {
        void withRecords_timestampType;
        SimpleRecord[] withRecords_records = new SimpleRecord[]{new SimpleRecord("first message".getBytes()), new SimpleRecord("second message".getBytes()), new SimpleRecord("third message".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$setUp$2(Iterable x$5, Iterable x$6) {
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$2(Iterable x$7, Iterable x$8) {
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$2(Iterable x$9, Iterable x$10) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$4(Map x$11) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$2(Iterable x$12, Iterable x$13) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$2(Iterable x$14, Iterable x$15) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assertions.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public LocalLeaderEndPointTest() {
        this.topic = "test";
    }

    private class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public boolean hasFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.hasFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ LocalLeaderEndPointTest kafka$server$LocalLeaderEndPointTest$CallbackResult$$$outer() {
            return LocalLeaderEndPointTest.this;
        }

        public CallbackResult() {
            if (LocalLeaderEndPointTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

