/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tools.MirrorMaker;
import kafka.tools.MirrorMaker$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\u0006\f\u0001AAQa\u0006\u0001\u0005\u0002aAQa\u0007\u0001\u0005BqAqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u0004:\u0001\u0001\u0006I!\f\u0005\u0006u\u0001!\te\u000f\u0005\u0006%\u0002!\te\u0015\u0005\u00061\u0002!\t!\u0017\u0005\u0006}\u0002!\ta \u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0005ii\u0015N\u001d:pe6\u000b7.\u001a:J]R,wM]1uS>tG+Z:u\u0015\taQ\"A\u0003u_>d7OC\u0001\u000f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0005Qi\u0011aC5oi\u0016<'/\u0019;j_:L!AF\n\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"A\u0006\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012!\b\t\u0004=\r*S\"A\u0010\u000b\u0005\u0001\n\u0013AC2pY2,7\r^5p]*\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%?\t\u00191+Z9\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!j\u0011AB:feZ,'/\u0003\u0002+O\tY1*\u00194lC\u000e{gNZ5h\u0003\u0019)\u00070\u001b;fIV\tQ\u0006\u0005\u0002/o5\tqF\u0003\u00021c\u00051\u0011\r^8nS\u000eT!AM\u001a\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00025k\u0005!Q\u000f^5m\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u0018\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003\u001d)\u00070\u001b;fI\u0002\nQa]3u+B$\"\u0001\u0010!\u0011\u0005urT\"A\u0011\n\u0005}\n#\u0001B+oSRDQ!Q\u0003A\u0002\t\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003\u00072k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b1!\u00199j\u0015\t9\u0005*A\u0004kkBLG/\u001a:\u000b\u0005%S\u0015!\u00026v]&$(\"A&\u0002\u0007=\u0014x-\u0003\u0002N\t\nAA+Z:u\u0013:4w\u000e\u000b\u0002\u0006\u001fB\u00111\tU\u0005\u0003#\u0012\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#\u0001\u001f)\u0005\u0019)\u0006CA\"W\u0013\t9FIA\u0005BMR,'/R1dQ\u00061C/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r^:UQJ|w\u000fV5nK>,H/\u0012=dKB$\u0018n\u001c8\u0015\u0005qR\u0006\"B.\b\u0001\u0004a\u0016AB9v_J,X\u000e\u0005\u0002^I:\u0011aL\u0019\t\u0003?\u0006j\u0011\u0001\u0019\u0006\u0003C>\ta\u0001\u0010:p_Rt\u0014BA2\"\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r\f\u0003\u0006B\u0004i]>\u0004\"!\u001b7\u000e\u0003)T!a\u001b$\u0002\rA\f'/Y7t\u0013\ti'NA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\n\u0001/\u0001\u0012|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018|CJ<W/\\3oiN<\u0016\u000e\u001e5OC6,7/ \u0015\u0005\u000fID\u0018\u0010\u0005\u0002tm6\tAO\u0003\u0002vU\u0006A\u0001O]8wS\u0012,'/\u0003\u0002xi\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#A\u001f?\"\u0003m\f!A_6\"\u0003u\fQa\u001b:bMR\f\u0001\u0006^3ti\u000e{W.\\5u\u001f\u001a47/\u001a;t%\u0016lwN^3O_:,\u00050[:uK:$Hk\u001c9jGN$2\u0001PA\u0001\u0011\u0015Y\u0006\u00021\u0001]Q\u0011A\u0001N\\8)\u000b!\u0011\b0a\u0002-\u0005id\u0018a\u0006;fgR\u001cu.\\7b'\u0016\u0004\u0018M]1uK\u0012\u0014VmZ3y)\ra\u0014Q\u0002\u0005\u00067&\u0001\r\u0001\u0018\u0015\u0005\u0013!tw\u000eK\u0003\neb\f\u0019\u0002\f\u0002{y\"Z\u0001!a\u0006\u0002\u001e\u0005}\u00111EA\u0013!\ri\u0014\u0011D\u0005\u0004\u00037\t#A\u00033faJ,7-\u0019;fI\u00069Q.Z:tC\u001e,\u0017EAA\u0011\u0003Q*6/\u001a\u0011uQ\u0016\u00043i\u001c8oK\u000e$XFY1tK\u0012\u0004S*\u001b:s_Jl\u0015m[3sA%t7\u000f^3bI\u0002B\u0013m[1!\u001b6\u0013\u0014FL\u0001\u0006g&t7-Z\u0011\u0003\u0003O\t1a\r\u00181\u0001")
public class MirrorMakerIntegrationTest
extends KafkaServerTestHarness {
    private final AtomicBoolean exited = new AtomicBoolean(false);

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = new Properties();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$2, x$3) -> this.exited().set(true));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        try {
            Assertions.assertFalse((boolean)this.exited().get());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCommitOffsetsThrowTimeoutException(String quorum) {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        consumerProps.put("default.api.timeout.ms", "1");
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"any"));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("test", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        Assertions.assertThrows(TimeoutException.class, () -> mirrorMakerConsumer.commit());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCommitOffsetsRemoveNonExistentTopics(String quorum) {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        consumerProps.put("default.api.timeout.ms", "2000");
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"any"));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("nonexistent-topic1", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("nonexistent-topic2", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        MirrorMaker$.MODULE$.commitOffsets(mirrorMakerConsumer);
        Assertions.assertTrue((boolean)mirrorMakerConsumer.offsets().isEmpty(), (String)"Offsets for non-existent topics should be removed");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCommaSeparatedRegex(String quorum) {
        String topic = "new-topic";
        String msg = "a test message";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("key.serializer", ByteArraySerializer.class);
        producerProps.put("value.serializer", ByteArraySerializer.class);
        MirrorMaker.MirrorMakerProducer producer = new MirrorMaker.MirrorMakerProducer(true, producerProps);
        MirrorMaker$.MODULE$.producer_$eq(producer);
        MirrorMaker$.MODULE$.producer().send(new ProducerRecord(topic, (Object)msg.getBytes()));
        MirrorMaker$.MODULE$.producer().close();
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"another_topic,new.*,foo"));
        mirrorMakerConsumer.init();
        try {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!MirrorMakerIntegrationTest.$anonfun$testCommaSeparatedRegex$1(mirrorMakerConsumer, topic, msg)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"MirrorMaker consumer should read the expected message from the expected topic within the timeout");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            consumer.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCommaSeparatedRegex$1(MirrorMaker.ConsumerWrapper mirrorMakerConsumer$2, String topic$1, String msg$1) {
        boolean bl;
        try {
            ConsumerRecord data = mirrorMakerConsumer$2.receive();
            String string = data.topic();
            if ((string != null ? !string.equals(topic$1) : topic$1 != null) || !new String((byte[])data.value()).equals(msg$1)) {
                return false;
            }
            bl = true;
        }
        catch (MirrorMaker.NoRecordsException noRecordsException) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ String $anonfun$testCommaSeparatedRegex$2() {
        return "MirrorMaker consumer should read the expected message from the expected topic within the timeout";
    }
}

