/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.GeoPointTermQuery;
import org.apache.lucene.search.GeoPointTermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.GeoUtils;

final class GeoPointTermQueryConstantScoreWrapper<Q extends GeoPointTermQuery>
extends Query {
    protected final Q query;

    protected GeoPointTermQueryConstantScoreWrapper(Q query) {
        this.query = query;
    }

    public String toString(String field) {
        return this.query.toString();
    }

    public final boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GeoPointTermQueryConstantScoreWrapper that = (GeoPointTermQueryConstantScoreWrapper)((Object)o);
        return this.query.equals(that.query) && this.getBoost() == that.getBoost();
    }

    public final int hashCode() {
        return 31 * super.hashCode() + this.query.hashCode();
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            private DocIdSet getDocIDs(LeafReaderContext context) throws IOException {
                Terms terms = context.reader().terms(((GeoPointTermQuery)((Object)GeoPointTermQueryConstantScoreWrapper.this.query)).field);
                if (terms == null) {
                    return DocIdSet.EMPTY;
                }
                GeoPointTermsEnum termsEnum = (GeoPointTermsEnum)GeoPointTermQueryConstantScoreWrapper.this.query.getTermsEnum(terms);
                assert (termsEnum != null);
                LeafReader reader = context.reader();
                DocIdSetBuilder builder = new DocIdSetBuilder(reader.maxDoc());
                PostingsEnum docs = null;
                SortedNumericDocValues sdv = reader.getSortedNumericDocValues(((GeoPointTermQuery)((Object)GeoPointTermQueryConstantScoreWrapper.this.query)).field);
                while (termsEnum.next() != null) {
                    docs = termsEnum.postings(docs, 0);
                    if (termsEnum.boundaryTerm()) {
                        int docId = docs.nextDoc();
                        do {
                            sdv.setDocument(docId);
                            for (int i = 0; i < sdv.count(); ++i) {
                                double lat;
                                long hash = sdv.valueAt(i);
                                double lon = GeoUtils.mortonUnhashLon(hash);
                                if (!termsEnum.postFilter(lon, lat = GeoUtils.mortonUnhashLat(hash))) continue;
                                builder.add(docId);
                            }
                        } while ((docId = docs.nextDoc()) != Integer.MAX_VALUE);
                        continue;
                    }
                    builder.add((DocIdSetIterator)docs);
                }
                return builder.build();
            }

            private Scorer scorer(DocIdSet set) throws IOException {
                if (set == null) {
                    return null;
                }
                DocIdSetIterator disi = set.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }

            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                Scorer scorer = this.scorer(this.getDocIDs(context));
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                return this.scorer(this.getDocIDs(context));
            }
        };
    }
}

