/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.jdbc;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public final class ConnectionPoolDataSource
implements DataSource {
    private final DataSource delegate;

    public ConnectionPoolDataSource(DataSource underlyingDataSource) {
        Preconditions.checkNotNull((Object)underlyingDataSource);
        ConfiguringConnectionFactory connectionFactory = new ConfiguringConnectionFactory(underlyingDataSource);
        GenericObjectPool objectPool = new GenericObjectPool();
        objectPool.setTestOnBorrow(false);
        objectPool.setTestOnReturn(false);
        objectPool.setTestWhileIdle(true);
        objectPool.setTimeBetweenEvictionRunsMillis(60000L);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)objectPool, null, "SELECT 1", false, false);
        this.delegate = new PoolingDataSource((ObjectPool)objectPool);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.delegate.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.delegate.setLogWriter(printWriter);
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this.delegate.setLoginTimeout(timeout);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    private static class ConfiguringConnectionFactory
    implements ConnectionFactory {
        private final DataSource underlyingDataSource;

        ConfiguringConnectionFactory(DataSource underlyingDataSource) {
            this.underlyingDataSource = underlyingDataSource;
        }

        public Connection createConnection() throws SQLException {
            Connection connection = this.underlyingDataSource.getConnection();
            connection.setTransactionIsolation(1);
            connection.setHoldability(2);
            return connection;
        }
    }
}

