/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.benchmark;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.benchmark.VectorBenchmarks;
import org.apache.mahout.common.TimingStatistics;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.VectorWritable;

public class SerializationBenchmark {
    public static final String SERIALIZE = "Serialize";
    public static final String DESERIALIZE = "Deserialize";
    private final VectorBenchmarks mark;

    public SerializationBenchmark(VectorBenchmarks mark) {
        this.mark = mark;
    }

    public void benchmark() throws IOException {
        this.serializeBenchmark();
        this.deserializeBenchmark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeBenchmark() throws IOException {
        TimingStatistics.Call call;
        int i;
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, new Path("/tmp/dense-vector"), IntWritable.class, VectorWritable.class);
        IntWritable one = new IntWritable(0);
        VectorWritable vec = new VectorWritable();
        TimingStatistics stats = new TimingStatistics();
        try {
            for (i = 0; i < this.mark.loop; ++i) {
                call = stats.newCall(this.mark.leadTimeUsec);
                vec.set(this.mark.vectors[0][this.mark.vIndex(i)]);
                writer.append((Writable)one, (Writable)vec);
                if (!call.end(this.mark.maxTimeUsec)) continue;
                break;
            }
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        this.mark.printStats(stats, SERIALIZE, "DenseVector");
        writer = new SequenceFile.Writer(fs, conf, new Path("/tmp/randsparse-vector"), IntWritable.class, VectorWritable.class);
        stats = new TimingStatistics();
        try {
            for (i = 0; i < this.mark.loop; ++i) {
                call = stats.newCall(this.mark.leadTimeUsec);
                vec.set(this.mark.vectors[1][this.mark.vIndex(i)]);
                writer.append((Writable)one, (Writable)vec);
                if (!call.end(this.mark.maxTimeUsec)) continue;
                break;
            }
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        this.mark.printStats(stats, SERIALIZE, "RandSparseVector");
        writer = new SequenceFile.Writer(fs, conf, new Path("/tmp/seqsparse-vector"), IntWritable.class, VectorWritable.class);
        stats = new TimingStatistics();
        try {
            for (i = 0; i < this.mark.loop; ++i) {
                call = stats.newCall(this.mark.leadTimeUsec);
                vec.set(this.mark.vectors[2][this.mark.vIndex(i)]);
                writer.append((Writable)one, (Writable)vec);
                if (!call.end(this.mark.maxTimeUsec)) continue;
                break;
            }
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        this.mark.printStats(stats, SERIALIZE, "SeqSparseVector");
    }

    public void deserializeBenchmark() throws IOException {
        this.doDeserializeBenchmark("DenseVector", "/tmp/dense-vector");
        this.doDeserializeBenchmark("RandSparseVector", "/tmp/randsparse-vector");
        this.doDeserializeBenchmark("SeqSparseVector", "/tmp/seqsparse-vector");
    }

    private void doDeserializeBenchmark(String name, String pathString) throws IOException {
        TimingStatistics stats = new TimingStatistics();
        TimingStatistics.Call call = stats.newCall(this.mark.leadTimeUsec);
        SequenceFileValueIterator iterator = new SequenceFileValueIterator(new Path(pathString), true, new Configuration());
        while (iterator.hasNext()) {
            iterator.next();
            call.end();
            call = stats.newCall(this.mark.leadTimeUsec);
        }
        iterator.close();
        this.mark.printStats(stats, DESERIALIZE, name);
    }
}

