/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text.wikipedia;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlInputFormat
extends TextInputFormat {
    private static final Logger log = LoggerFactory.getLogger(XmlInputFormat.class);
    public static final String START_TAG_KEY = "xmlinput.start";
    public static final String END_TAG_KEY = "xmlinput.end";

    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) {
        try {
            return new XmlRecordReader((FileSplit)split, context.getConfiguration());
        }
        catch (IOException ioe) {
            log.warn("Error while creating XmlRecordReader", (Throwable)ioe);
            return null;
        }
    }

    public static class XmlRecordReader
    extends RecordReader<LongWritable, Text> {
        private final byte[] startTag;
        private final byte[] endTag;
        private final long start;
        private final long end;
        private final FSDataInputStream fsin;
        private final DataOutputBuffer buffer = new DataOutputBuffer();
        private LongWritable currentKey;
        private Text currentValue;

        public XmlRecordReader(FileSplit split, Configuration conf) throws IOException {
            this.startTag = conf.get(XmlInputFormat.START_TAG_KEY).getBytes(Charsets.UTF_8);
            this.endTag = conf.get(XmlInputFormat.END_TAG_KEY).getBytes(Charsets.UTF_8);
            this.start = split.getStart();
            this.end = this.start + split.getLength();
            Path file = split.getPath();
            FileSystem fs = file.getFileSystem(conf);
            this.fsin = fs.open(split.getPath());
            this.fsin.seek(this.start);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next(LongWritable key, Text value) throws IOException {
            if (this.fsin.getPos() < this.end && this.readUntilMatch(this.startTag, false)) {
                try {
                    this.buffer.write(this.startTag);
                    if (this.readUntilMatch(this.endTag, true)) {
                        key.set(this.fsin.getPos());
                        value.set(this.buffer.getData(), 0, this.buffer.getLength());
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.buffer.reset();
                }
            }
            return false;
        }

        public void close() throws IOException {
            Closeables.close((Closeable)this.fsin, (boolean)true);
        }

        public float getProgress() throws IOException {
            return (float)(this.fsin.getPos() - this.start) / (float)(this.end - this.start);
        }

        private boolean readUntilMatch(byte[] match, boolean withinBlock) throws IOException {
            int i = 0;
            do {
                int b;
                if ((b = this.fsin.read()) == -1) {
                    return false;
                }
                if (withinBlock) {
                    this.buffer.write(b);
                }
                if (b == match[i]) {
                    if (++i < match.length) continue;
                    return true;
                }
                i = 0;
            } while (withinBlock || i != 0 || this.fsin.getPos() < this.end);
            return false;
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return this.currentKey;
        }

        public Text getCurrentValue() throws IOException, InterruptedException {
            return this.currentValue;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            this.currentKey = new LongWritable();
            this.currentValue = new Text();
            return this.next(this.currentKey, this.currentValue);
        }
    }
}

