/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr.pacman;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.maven.jxr.log.Log;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.FileManager;
import org.apache.maven.jxr.pacman.JavaFile;
import org.apache.maven.jxr.pacman.PackageType;
import org.codehaus.plexus.util.DirectoryScanner;

public class PackageManager {
    private final Log log;
    private Set<Path> directories = new HashSet<Path>();
    private Hashtable<String, PackageType> packages = new Hashtable();
    private PackageType defaultPackage = new PackageType();
    private FileManager fileManager;
    private String[] excludes = null;
    private String[] includes = new String[]{"**/*.java"};

    public PackageManager(Log log, FileManager fileManager) {
        this.log = log;
        this.fileManager = fileManager;
    }

    public PackageType getPackageType(String name) {
        if (name == null) {
            return this.defaultPackage;
        }
        return this.packages.get(name);
    }

    public void addPackageType(PackageType packageType) {
        this.packages.put(packageType.getName(), packageType);
    }

    public Enumeration<PackageType> getPackageTypes() {
        return this.packages.elements();
    }

    private void parse(String directory) {
        this.log.debug("Scanning " + directory);
        DirectoryScanner directoryScanner = new DirectoryScanner();
        Path baseDir = Paths.get(directory, new String[0]);
        directoryScanner.setBasedir(baseDir.toFile());
        directoryScanner.setExcludes(this.excludes);
        directoryScanner.setIncludes(this.includes);
        directoryScanner.scan();
        for (String file : directoryScanner.getIncludedFiles()) {
            this.log.debug("parsing... " + file);
            try {
                Path fileName = baseDir.resolve(file);
                JavaFile jfi = this.fileManager.getFile(fileName);
                PackageType jp = this.getPackageType(jfi.getPackageType().getName());
                if (jp == null) {
                    this.addPackageType(jfi.getPackageType());
                    jp = jfi.getPackageType();
                }
                if (jfi.getClassTypes() == null || jfi.getClassTypes().isEmpty()) continue;
                for (ClassType ct : jfi.getClassTypes()) {
                    jp.addClassType(ct);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void process(Path directory) {
        if (this.directories.add(directory)) {
            this.parse(directory.toString());
        }
    }

    public void dump() {
        this.log.debug("Dumping out PackageManager structure");
        Enumeration<PackageType> pts = this.getPackageTypes();
        while (pts.hasMoreElements()) {
            PackageType current = pts.nextElement();
            this.log.debug(current.getName());
            Enumeration<ClassType> classes = current.getClassTypes();
            while (classes.hasMoreElements()) {
                ClassType currentClass = classes.nextElement();
                this.log.debug("\t" + currentClass.getName());
            }
        }
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }
}

