/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.remote.m2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.repository.local.m2.LocalRepositoryM2;
import org.apache.maven.mercury.repository.metadata.AddVersionOperation;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataBuilder;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.metadata.StringOperand;
import org.apache.maven.mercury.util.FileUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class RepositoryUtilM2 {
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(RepositoryUtilM2.class);
    private static final Language _lang = new DefaultLanguage(RepositoryUtilM2.class);

    public static void flip(LocalRepositoryM2 repo, File dest) {
        if (repo == null) {
            throw new IllegalArgumentException(_lang.getMessage("lrepo.null", new String[0]));
        }
        File lDir = repo.getDirectory();
        if (lDir == null) {
            throw new IllegalArgumentException(_lang.getMessage("lrepo.no.dir", new String[0]));
        }
        if (!lDir.exists() || !lDir.isDirectory()) {
            throw new IllegalArgumentException(_lang.getMessage("lrepo.dir.not.exists", new String[]{lDir.toString()}));
        }
        if (dest.exists() && !dest.isFile()) {
            throw new IllegalArgumentException(_lang.getMessage("dest.is.file", new String[]{dest.toString()}));
        }
    }

    public static void flipLocalFolderToRemoteRepository(File repoDir) {
        if (!repoDir.exists() || !repoDir.isDirectory()) {
            throw new IllegalArgumentException(_lang.getMessage("lrepo.dir.not.exists", new String[]{repoDir.toString()}));
        }
        FileUtil.renameFile((File)repoDir, (String)"maven-metadata-local.xml", (String)"maven-metadata.xml");
    }

    private static final void findGA(File dir) throws MetadataException, IOException {
        if (dir.isFile()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length < 1) {
            return;
        }
        int dep = FileUtil.depth((File)dir);
        ArrayList<AddVersionOperation> vo = null;
        if (dep <= 1) {
            vo = new ArrayList<AddVersionOperation>();
        }
        for (File f : files) {
            if (f.isFile()) {
                return;
            }
            if (dep == 1) {
                vo.add(new AddVersionOperation(new StringOperand(f.getName())));
                continue;
            }
            RepositoryUtilM2.findGA(f);
        }
        if (dep == 1) {
            Metadata md = new Metadata();
            byte[] mdBytes = MetadataBuilder.changeMetadata((Metadata)md, vo);
            FileUtil.writeRawData((File)new File(dir, "maven-metadata.xml"), (byte[])mdBytes);
        } else if (dep == 0) {
            // empty if block
        }
    }
}

