/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;
import org.apache.maven.plugin.war.packaging.WarPostPackagingTask;
import org.apache.maven.plugin.war.util.WebappStructureSerializer;

public class SaveWebappStructurePostPackagingTask
implements WarPostPackagingTask {
    private final File targetFile;
    private final WebappStructureSerializer serialier;

    public SaveWebappStructurePostPackagingTask(File targetFile) {
        this.targetFile = targetFile;
        this.serialier = new WebappStructureSerializer();
    }

    public void performPostPackaging(WarPackagingContext context) throws MojoExecutionException, MojoFailureException {
        if (this.targetFile == null) {
            context.getLog().debug((CharSequence)"Cache usage is disabled, not saving webapp structure.");
        } else {
            try {
                this.serialier.toXml(context.getWebappStructure(), this.targetFile);
                context.getLog().debug((CharSequence)"Cache saved successfully.");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not save webapp structure", (Exception)e);
            }
        }
    }
}

