/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;

final class SurefireDependencyResolver {
    static final String PROVIDER_GROUP_ID = "org.apache.maven.surefire";
    private static final String[] PROVIDER_CLASSPATH_ORDER = new String[]{"surefire-junit3", "surefire-junit4", "surefire-junit47", "surefire-testng", "surefire-junit-platform", "surefire-api", "surefire-logger-api", "surefire-shared-utils", "common-java5", "common-junit3", "common-junit4", "common-junit48", "common-testng-utils"};
    private final RepositorySystem repositorySystem;
    private final ConsoleLogger log;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> pluginRemoteRepositories;
    private final List<ArtifactRepository> projectRemoteRepositories;
    private final String pluginName;
    private final DependencyResolver dependencyResolver;
    private final boolean offline;

    SurefireDependencyResolver(RepositorySystem repositorySystem, ConsoleLogger log, ArtifactRepository localRepository, List<ArtifactRepository> pluginRemoteRepositories, List<ArtifactRepository> projectRemoteRepositories, String pluginName, DependencyResolver dependencyResolver, boolean offline) {
        this.repositorySystem = repositorySystem;
        this.log = log;
        this.localRepository = localRepository;
        this.pluginRemoteRepositories = pluginRemoteRepositories;
        this.projectRemoteRepositories = projectRemoteRepositories;
        this.pluginName = pluginName;
        this.dependencyResolver = dependencyResolver;
        this.offline = offline;
    }

    static boolean isWithinVersionSpec(@Nullable Artifact artifact, @Nonnull String versionSpec) {
        if (artifact == null) {
            return false;
        }
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)versionSpec);
            try {
                return range.containsVersion(artifact.getSelectedVersion());
            }
            catch (NullPointerException e) {
                return range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getBaseVersion()));
            }
        }
        catch (InvalidVersionSpecificationException | OverConstrainedVersionException e) {
            throw new RuntimeException("Bug in plugin. Please report with stacktrace");
        }
    }

    Map<String, Artifact> resolvePluginDependencies(ProjectBuildingRequest request, Plugin plugin, Map<String, Artifact> pluginResolvedDependencies) throws MojoExecutionException {
        List pluginDependencies = plugin.getDependencies();
        try {
            Iterable resolvedArtifacts = this.dependencyResolver.resolveDependencies(request, (Collection)pluginDependencies, null, (TransformableFilter)ScopeFilter.including(RuntimeArtifactFilter.SCOPES));
            LinkedHashMap<String, Artifact> resolved = new LinkedHashMap<String, Artifact>();
            for (ArtifactResult resolvedArtifact : resolvedArtifacts) {
                Artifact artifact = resolvedArtifact.getArtifact();
                String key = artifact.getGroupId() + ":" + artifact.getArtifactId();
                Artifact resolvedPluginDependency = pluginResolvedDependencies.get(key);
                if (resolvedPluginDependency == null) continue;
                resolved.put(key, artifact);
            }
            return resolved;
        }
        catch (DependencyResolverException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    ArtifactResolutionResult resolvePluginArtifact(Artifact artifact) {
        return this.resolvePluginArtifact(artifact, new RuntimeArtifactFilter());
    }

    ArtifactResolutionResult resolveProjectArtifact(Artifact artifact) {
        return this.resolveProjectArtifact(artifact, new RuntimeArtifactFilter());
    }

    private ArtifactResolutionResult resolvePluginArtifact(Artifact artifact, ArtifactFilter filter) {
        return this.resolveArtifact(artifact, this.pluginRemoteRepositories, filter);
    }

    private ArtifactResolutionResult resolveProjectArtifact(Artifact artifact, ArtifactFilter filter) {
        return this.resolveArtifact(artifact, this.projectRemoteRepositories, filter);
    }

    private ArtifactResolutionResult resolveArtifact(Artifact artifact, List<ArtifactRepository> repositories, ArtifactFilter filter) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setOffline(this.offline).setArtifact(artifact).setLocalRepository(this.localRepository).setResolveTransitively(true).setCollectionFilter(filter).setRemoteRepositories(repositories);
        return this.repositorySystem.resolve(request);
    }

    @Nonnull
    Set<Artifact> getProviderClasspath(String providerArtifactId, String providerVersion) {
        Dependency provider = SurefireDependencyResolver.toProviderDependency(providerArtifactId, providerVersion);
        Artifact providerArtifact = this.repositorySystem.createDependencyArtifact(provider);
        ArtifactResolutionResult result = this.resolvePluginArtifact(providerArtifact);
        if (this.log.isDebugEnabled()) {
            for (Artifact artifact : result.getArtifacts()) {
                String artifactPath = artifact.getFile().getAbsolutePath();
                String scope = artifact.getScope();
                this.log.debug("Adding to " + this.pluginName + " test classpath: " + artifactPath + " Scope: " + scope);
            }
        }
        return SurefireDependencyResolver.orderProviderArtifacts(result.getArtifacts());
    }

    @Nonnull
    Map<String, Artifact> getProviderClasspathAsMap(String providerArtifactId, String providerVersion) {
        return ArtifactUtils.artifactMapByVersionlessId(this.getProviderClasspath(providerArtifactId, providerVersion));
    }

    private static Set<Artifact> orderProviderArtifacts(Set<Artifact> providerArtifacts) {
        LinkedHashSet<Artifact> orderedProviderArtifacts = new LinkedHashSet<Artifact>();
        for (String order : PROVIDER_CLASSPATH_ORDER) {
            Iterator<Artifact> providerArtifactsIt = providerArtifacts.iterator();
            while (providerArtifactsIt.hasNext()) {
                Artifact providerArtifact = providerArtifactsIt.next();
                if (!providerArtifact.getArtifactId().equals(order)) continue;
                orderedProviderArtifacts.add(providerArtifact);
                providerArtifactsIt.remove();
            }
        }
        orderedProviderArtifacts.addAll(providerArtifacts);
        return orderedProviderArtifacts;
    }

    private static Dependency toProviderDependency(String providerArtifactId, String providerVersion) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(PROVIDER_GROUP_ID);
        dependency.setArtifactId(providerArtifactId);
        dependency.setVersion(providerVersion);
        dependency.setType("jar");
        return dependency;
    }

    static class RuntimeArtifactFilter
    implements ArtifactFilter {
        private static final Collection<String> SCOPES = Arrays.asList("compile", "compile+runtime", "runtime");
        private final Artifact filter;

        RuntimeArtifactFilter() {
            this(null);
        }

        RuntimeArtifactFilter(Artifact filter) {
            this.filter = filter;
        }

        public boolean include(Artifact artifact) {
            String scope = artifact.getScope();
            return !(this.filter != null && !artifact.equals(this.filter) || artifact.isOptional() || scope != null && !SCOPES.contains(scope));
        }
    }
}

