/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.SQLException;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.jdbc.UncheckedSQLException;
import org.apache.metamodel.jdbc.dialects.IQueryRewriter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.QueryParameter;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.FormatHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);

    public static MetaModelException wrapException(SQLException e, String actionDescription, JdbcActionType actionType) throws MetaModelException {
        String message = e.getMessage();
        message = message == null || message.isEmpty() ? "Could not " + actionDescription : "Could not " + actionDescription + ": " + message;
        logger.error(message + ", Error code={}, SQL state={}", new Object[]{e.getErrorCode(), e.getSQLState(), e});
        SQLException nextException = e.getNextException();
        if (nextException != null) {
            logger.error("Next SQL exception: " + nextException.getMessage(), (Throwable)nextException);
        }
        switch (actionType) {
            case QUERY: 
            case UPDATE: {
                return new UncheckedSQLException(e);
            }
        }
        return new MetaModelException(message, (Exception)e);
    }

    public static String getValueAsSql(Column column, Object value, IQueryRewriter queryRewriter) {
        if (value == null) {
            return "NULL";
        }
        ColumnType columnType = column.getType();
        if (columnType.isLiteral() && value instanceof String) {
            value = queryRewriter.escapeQuotes((String)value);
        }
        String formatSqlValue = FormatHelper.formatSqlValue((ColumnType)columnType, (Object)value);
        return formatSqlValue;
    }

    public static String createWhereClause(List<FilterItem> whereItems, IQueryRewriter queryRewriter, boolean inlineValues) {
        if (whereItems.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE ");
        boolean firstValue = true;
        for (FilterItem whereItem : whereItems) {
            if (firstValue) {
                firstValue = false;
            } else {
                sb.append(" AND ");
            }
            if (!inlineValues && JdbcUtils.isPreparedParameterCandidate(whereItem)) {
                whereItem = new FilterItem(whereItem.getSelectItem(), whereItem.getOperator(), (Object)new QueryParameter());
            }
            String whereItemLabel = queryRewriter.rewriteFilterItem(whereItem);
            sb.append(whereItemLabel);
        }
        return sb.toString();
    }

    public static boolean isPreparedParameterCandidate(FilterItem whereItem) {
        return !whereItem.isCompoundFilter() && !OperatorType.IN.equals(whereItem.getOperator()) && whereItem.getOperand() != null;
    }

    public static String[] getTableTypesAsStrings(TableType[] tableTypes) {
        String[] types = new String[tableTypes.length];
        for (int i = 0; i < types.length; ++i) {
            if (tableTypes[i] == TableType.OTHER) {
                types = null;
                break;
            }
            types[i] = tableTypes[i].toString();
        }
        return types;
    }

    public static enum JdbcActionType {
        QUERY,
        UPDATE,
        METADATA,
        COMMIT_ROLLBACK,
        OTHER;

    }
}

