/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.jdbc.SplitQueriesDataSet;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromClause;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.FunctionType;
import org.apache.metamodel.query.GroupByItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuerySplitter {
    public static final long DEFAULT_MAX_ROWS = 300000L;
    private static final int MINIMUM_MAX_ROWS = 100;
    private static final Logger logger = LoggerFactory.getLogger(QuerySplitter.class);
    private final Query _query;
    private final DataContext _dataContext;
    private long _maxRows = 300000L;
    private Long _cachedRowCount = null;

    public QuerySplitter(DataContext dc, Query q) {
        if (dc == null) {
            throw new IllegalArgumentException("DataContext cannot be null");
        }
        if (q == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        this._dataContext = dc;
        this._query = q;
    }

    public List<Query> splitQuery() {
        ArrayList<Query> result = new ArrayList<Query>();
        if (this.isSplittable()) {
            if (this.getRowCount() > this._maxRows) {
                Integer subQueryIndex = this.getSubQueryFromItemIndex();
                List<Query> splitQueries = null;
                if (subQueryIndex != null) {
                    splitQueries = this.splitQueryBasedOnSubQueries(subQueryIndex);
                } else {
                    List<Column> splitColumns = this.getSplitColumns();
                    splitQueries = this.splitQueryBasedOnColumns(splitColumns);
                }
                result.addAll(splitQueries);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info("Accepted query, maxRows not exceeded: " + this._query);
                }
                result.add(this._query);
            }
        }
        if (result.isEmpty()) {
            logger.debug("Cannot further split query: {}", (Object)this._query);
            result.add(this._query);
        }
        return result;
    }

    private List<Query> splitQueryBasedOnColumns(List<Column> splitColumns) {
        ArrayList<Query> result = new ArrayList<Query>();
        if (splitColumns.isEmpty() || this.getRowCount() <= this._maxRows) {
            if (this.getRowCount() > 0L) {
                result.add(this._query);
            }
        } else {
            Column firstColumn = splitColumns.get(0);
            splitColumns.remove(0);
            List<Query> splitQueries = this.splitQueryBasedOnColumn(firstColumn);
            for (Query splitQuery : splitQueries) {
                QuerySplitter qs = new QuerySplitter(this._dataContext, splitQuery).setMaxRows(this._maxRows);
                if (qs.getRowCount() > this._maxRows) {
                    result.addAll(qs.splitQueryBasedOnColumns(splitColumns));
                    continue;
                }
                if (qs.getRowCount() <= 0L) continue;
                result.add(splitQuery);
            }
        }
        return result;
    }

    private List<Query> splitQueryBasedOnColumn(Column column) {
        SelectItem maxItem = new SelectItem((FunctionType)FunctionType.MAX, column);
        SelectItem minItem = new SelectItem((FunctionType)FunctionType.MIN, column);
        Query q = new Query().from(column.getTable()).select(new SelectItem[]{maxItem, minItem});
        Row row = MetaModelHelper.executeSingleRowQuery((DataContext)this._dataContext, (Query)q);
        long max = QuerySplitter.ceil((Number)row.getValue(maxItem));
        long min = QuerySplitter.floor((Number)row.getValue(minItem));
        long wholeRange = max - min;
        ArrayList<Query> result = new ArrayList<Query>();
        if (wholeRange <= 1L) {
            result.add(this._query);
        } else {
            long numSplits = QuerySplitter.ceil(this.getRowCount() / this._maxRows);
            if (numSplits < 2L) {
                numSplits = 2L;
            }
            int splitInterval = (int)(wholeRange / numSplits);
            int i = 0;
            while ((long)i < numSplits) {
                q = this._query.clone();
                long lowLimit = min + (long)(i * splitInterval);
                long highLimit = lowLimit + (long)splitInterval;
                FilterItem lowerThanFilter = new FilterItem(new SelectItem(column), OperatorType.LESS_THAN, (Object)highLimit);
                FilterItem higherThanFilter = new FilterItem(new SelectItem(column), OperatorType.GREATER_THAN, (Object)lowLimit);
                FilterItem equalsFilter = new FilterItem(new SelectItem(column), OperatorType.EQUALS_TO, (Object)lowLimit);
                if (i == 0) {
                    FilterItem nullFilter = new FilterItem(new SelectItem(column), OperatorType.EQUALS_TO, null);
                    FilterItem orFilterItem = new FilterItem(new FilterItem[]{lowerThanFilter, nullFilter});
                    q.where(new FilterItem[]{orFilterItem});
                } else if ((long)(i + 1) == numSplits) {
                    FilterItem orFilterItem = new FilterItem(new FilterItem[]{higherThanFilter, equalsFilter});
                    q.where(new FilterItem[]{orFilterItem});
                } else {
                    higherThanFilter = new FilterItem(new FilterItem[]{higherThanFilter, equalsFilter});
                    lowerThanFilter = new FilterItem(new FilterItem[]{lowerThanFilter, equalsFilter});
                    q.where(new FilterItem[]{higherThanFilter});
                    q.where(new FilterItem[]{lowerThanFilter});
                }
                result.add(q);
                ++i;
            }
        }
        return result;
    }

    private static long floor(Number value) {
        Double floor = Math.floor(value.doubleValue());
        return floor.longValue();
    }

    private static long ceil(Number value) {
        Double ceil = Math.ceil(value.doubleValue());
        return ceil.longValue();
    }

    private List<Query> splitQueryBasedOnSubQueries(int fromItemIndex) {
        Query subQuery = ((FromItem)this._query.getFromClause().getItem(fromItemIndex)).getSubQuery();
        QuerySplitter subQuerySplitter = new QuerySplitter(this._dataContext, subQuery);
        subQuerySplitter.setMaxRows(this._maxRows);
        List<Query> splitQueries = subQuerySplitter.splitQuery();
        ArrayList<Query> result = new ArrayList<Query>(splitQueries.size());
        for (Query splitQuery : splitQueries) {
            Query newQuery = this._query.clone();
            FromClause fromClause = newQuery.getFromClause();
            String alias = ((FromItem)fromClause.getItem(fromItemIndex)).getAlias();
            fromClause.removeItem(fromItemIndex);
            newQuery.from(new FromItem[]{new FromItem(splitQuery).setAlias(alias)});
            result.add(newQuery);
        }
        return result;
    }

    private Integer getSubQueryFromItemIndex() {
        List fromItems = this._query.getFromClause().getItems();
        for (int i = 0; i < fromItems.size(); ++i) {
            Query subQuery = ((FromItem)fromItems.get(i)).getSubQuery();
            if (subQuery == null || !QuerySplitter.isSplittable(subQuery)) continue;
            return i;
        }
        return null;
    }

    private boolean isSplittable() {
        return QuerySplitter.isSplittable(this._query);
    }

    public static boolean isSplittable(Query q) {
        return q.getOrderByClause().getItemCount() == 0;
    }

    private List<Column> getSplitColumns() {
        ArrayList<Column> result = new ArrayList<Column>();
        if (this._query.getGroupByClause().getItemCount() != 0) {
            List groupByItems = this._query.getGroupByClause().getItems();
            for (GroupByItem groupByItem : groupByItems) {
                Column column = groupByItem.getSelectItem().getColumn();
                if (column == null) continue;
                if (column.isIndexed()) {
                    result.add(0, column);
                    continue;
                }
                result.add(column);
            }
        } else {
            List fromItems = this._query.getFromClause().getItems();
            for (FromItem fromItem : fromItems) {
                if (fromItem.getTable() != null) {
                    QuerySplitter.addColumnsToResult(fromItem.getTable(), result);
                }
                if (fromItem.getJoin() == null || fromItem.getAlias() != null) continue;
                if (fromItem.getLeftSide().getTable() != null) {
                    QuerySplitter.addColumnsToResult(fromItem.getLeftSide().getTable(), result);
                }
                if (fromItem.getRightSide().getTable() == null) continue;
                QuerySplitter.addColumnsToResult(fromItem.getRightSide().getTable(), result);
            }
        }
        return result;
    }

    private static void addColumnsToResult(Table table, List<Column> result) {
        for (Column column : table.getNumberColumns()) {
            if (column.isIndexed()) {
                result.add(0, column);
                continue;
            }
            result.add(column);
        }
    }

    public long getRowCount() {
        if (this._cachedRowCount == null) {
            this._cachedRowCount = this.getRowCount(this._query);
        }
        return this._cachedRowCount;
    }

    private long getRowCount(Query q) {
        q = q.clone();
        SelectItem countAllItem = SelectItem.getCountAllItem();
        if (q.getGroupByClause().getItemCount() > 0) {
            q = new Query().from(new FromItem[]{new FromItem(q).setAlias("sq")}).select(new SelectItem[]{countAllItem});
        } else {
            q.getSelectClause().removeItems();
            q.select(new SelectItem[]{countAllItem});
        }
        Row row = MetaModelHelper.executeSingleRowQuery((DataContext)this._dataContext, (Query)q);
        Number count = (Number)row.getValue(countAllItem);
        return count.longValue();
    }

    public QuerySplitter setMaxRows(long maxRows) {
        if (maxRows < 100L) {
            throw new IllegalArgumentException("maxRows must be higher than 100");
        }
        this._maxRows = maxRows;
        return this;
    }

    public DataSet executeQueries() {
        return this.executeQueries(this.splitQuery());
    }

    public DataSet executeQueries(List<Query> splitQueries) {
        return new SplitQueriesDataSet(this._dataContext, splitQueries);
    }
}

