/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.DefaultQueryRewriter;
import org.apache.metamodel.query.Query;

public abstract class LimitOffsetQueryRewriter
extends DefaultQueryRewriter {
    public LimitOffsetQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public final boolean isFirstRowSupported(Query query) {
        return true;
    }

    @Override
    public final boolean isMaxRowsSupported() {
        return true;
    }

    @Override
    public String rewriteQuery(Query query) {
        String queryString = super.rewriteQuery(query);
        Integer maxRows = query.getMaxRows();
        Integer firstRow = query.getFirstRow();
        if (maxRows != null || firstRow != null) {
            if (maxRows == null) {
                maxRows = Integer.MAX_VALUE;
            }
            queryString = queryString + " LIMIT " + maxRows;
            if (firstRow != null && firstRow > 1) {
                int offset = firstRow - 1;
                queryString = queryString + " OFFSET " + offset;
            }
        }
        return queryString;
    }
}

