/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bitpacking;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.Log;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.bitpacking.BitPacking;
import org.apache.parquet.io.ParquetDecodingException;

public class BitPackingValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(BitPackingValuesReader.class);
    private ByteArrayInputStream in;
    private BitPacking.BitPackingReader bitPackingReader;
    private final int bitsPerValue;
    private int nextOffset;

    public BitPackingValuesReader(int bound) {
        this.bitsPerValue = BytesUtils.getWidthFromMaxInt((int)bound);
    }

    @Override
    public int readInteger() {
        try {
            return this.bitPackingReader.read();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        int effectiveBitLength = valueCount * this.bitsPerValue;
        int length = BytesUtils.paddedByteCountFromBits((int)effectiveBitLength);
        if (Log.DEBUG) {
            LOG.debug((Object)("reading " + length + " bytes for " + valueCount + " values of size " + this.bitsPerValue + " bits."));
        }
        this.in = new ByteArrayInputStream(in, offset, length);
        this.bitPackingReader = BitPacking.createBitPackingReader((int)this.bitsPerValue, (InputStream)this.in, (long)valueCount);
        this.nextOffset = offset + length;
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

