/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmpbox;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public final class DateConverter {
    private static final SimpleDateFormat[] POTENTIAL_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEEE, dd MMM yyyy hh:mm:ss a"), new SimpleDateFormat("EEEE, MMM dd, yyyy hh:mm:ss a"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S")};

    private DateConverter() {
    }

    public static Calendar toCalendar(String date) throws IOException {
        GregorianCalendar retval;
        block25: {
            retval = null;
            if (date != null && date.trim().length() > 0) {
                int month = 1;
                int day = 1;
                int hour = 0;
                int minute = 0;
                int second = 0;
                try {
                    SimpleTimeZone zone = null;
                    if (Pattern.matches("^\\d{4}-\\d{2}-\\d{2}T.*", date)) {
                        return DateConverter.fromISO8601(date);
                    }
                    if (date.startsWith("D:")) {
                        date = date.substring(2, date.length());
                    }
                    if ((date = date.replaceAll("[-:T]", "")).length() < 4) {
                        throw new IOException("Error: Invalid date format '" + date + "'");
                    }
                    int year = Integer.parseInt(date.substring(0, 4));
                    if (date.length() >= 6) {
                        month = Integer.parseInt(date.substring(4, 6));
                    }
                    if (date.length() >= 8) {
                        day = Integer.parseInt(date.substring(6, 8));
                    }
                    if (date.length() >= 10) {
                        hour = Integer.parseInt(date.substring(8, 10));
                    }
                    if (date.length() >= 12) {
                        minute = Integer.parseInt(date.substring(10, 12));
                    }
                    int timeZonePos = 12;
                    if (date.length() - 12 > 5 || date.length() - 12 == 3 && date.endsWith("Z")) {
                        if (date.length() >= 14) {
                            second = Integer.parseInt(date.substring(12, 14));
                        }
                        timeZonePos = 14;
                    } else {
                        second = 0;
                    }
                    if (date.length() >= timeZonePos + 1) {
                        char sign = date.charAt(timeZonePos);
                        if (sign == 'Z') {
                            zone = new SimpleTimeZone(0, "Unknown");
                        } else {
                            int hours = 0;
                            int minutes = 0;
                            if (date.length() >= timeZonePos + 3) {
                                hours = sign == '+' ? Integer.parseInt(date.substring(timeZonePos + 1, timeZonePos + 3)) : -Integer.parseInt(date.substring(timeZonePos, timeZonePos + 2));
                            }
                            if (sign == '+') {
                                if (date.length() >= timeZonePos + 5) {
                                    minutes = Integer.parseInt(date.substring(timeZonePos + 3, timeZonePos + 5));
                                }
                            } else if (date.length() >= timeZonePos + 4) {
                                minutes = Integer.parseInt(date.substring(timeZonePos + 2, timeZonePos + 4));
                            }
                            zone = new SimpleTimeZone(hours * 60 * 60 * 1000 + minutes * 60 * 1000, "Unknown");
                        }
                    }
                    retval = zone == null ? new GregorianCalendar() : new GregorianCalendar(zone);
                    retval.clear();
                    retval.set(year, month - 1, day, hour, minute, second);
                }
                catch (NumberFormatException e) {
                    if (date.substring(date.length() - 3, date.length() - 2).equals(":") && (date.substring(date.length() - 6, date.length() - 5).equals("+") || date.substring(date.length() - 6, date.length() - 5).equals("-"))) {
                        date = date.substring(0, date.length() - 3) + date.substring(date.length() - 2);
                    }
                    for (int i = 0; retval == null && i < POTENTIAL_FORMATS.length; ++i) {
                        try {
                            Date utilDate = POTENTIAL_FORMATS[i].parse(date);
                            retval = new GregorianCalendar();
                            retval.setTime(utilDate);
                            continue;
                        }
                        catch (ParseException pe) {
                            // empty catch block
                        }
                    }
                    if (retval != null) break block25;
                    throw new IOException("Error converting date:" + date, e);
                }
            }
        }
        return retval;
    }

    public static String toISO8601(Calendar cal) {
        return DateConverter.toISO8601(cal, false);
    }

    public static String toISO8601(Calendar cal, boolean printMillis) {
        int timeZone;
        StringBuffer retval = new StringBuffer();
        retval.append(cal.get(1));
        retval.append("-");
        retval.append(String.format("%02d", cal.get(2) + 1));
        retval.append("-");
        retval.append(String.format("%02d", cal.get(5)));
        retval.append("T");
        retval.append(String.format("%02d", cal.get(11)));
        retval.append(":");
        retval.append(String.format("%02d", cal.get(12)));
        retval.append(":");
        retval.append(String.format("%02d", cal.get(13)));
        if (printMillis) {
            retval.append(".");
            retval.append(String.format("%03d", cal.get(14)));
        }
        if ((timeZone = cal.get(15) + cal.get(16)) < 0) {
            retval.append("-");
        } else {
            retval.append("+");
        }
        timeZone = Math.abs(timeZone);
        int hours = timeZone / 1000 / 60 / 60;
        int minutes = (timeZone - hours * 1000 * 60 * 60) / 1000 / 1000;
        if (hours < 10) {
            retval.append("0");
        }
        retval.append(Integer.toString(hours));
        retval.append(":");
        if (minutes < 10) {
            retval.append("0");
        }
        retval.append(Integer.toString(minutes));
        return retval.toString();
    }

    private static Calendar fromISO8601(String dateString) {
        Pattern timeZonePattern = Pattern.compile("[\\d-]*T?[\\d-\\.]([A-Z]{1,4})$|(.*\\d*)([A-Z][a-z]+\\/[A-Z][a-z]+)$");
        Matcher timeZoneMatcher = timeZonePattern.matcher(dateString);
        String timeZoneString = null;
        while (timeZoneMatcher.find()) {
            for (int i = 1; i <= timeZoneMatcher.groupCount(); ++i) {
                if (timeZoneMatcher.group(i) == null) continue;
                timeZoneString = timeZoneMatcher.group(i);
            }
        }
        if (timeZoneString != null) {
            Calendar cal = DatatypeConverter.parseDateTime((String)dateString.substring(0, dateString.indexOf(timeZoneString)));
            TimeZone z = TimeZone.getTimeZone(timeZoneString);
            cal.setTimeZone(z);
            return cal;
        }
        int teeIndex = dateString.indexOf(84);
        if (teeIndex == -1) {
            return DatatypeConverter.parseDateTime((String)dateString);
        }
        int plusIndex = dateString.indexOf(43, teeIndex + 1);
        int minusIndex = dateString.indexOf(45, teeIndex + 1);
        if (plusIndex == -1 && minusIndex == -1) {
            return DatatypeConverter.parseDateTime((String)dateString);
        }
        if ((plusIndex = Math.max(plusIndex, minusIndex)) - teeIndex == 6) {
            String toParse = dateString.substring(0, plusIndex) + ":00" + dateString.substring(plusIndex);
            return DatatypeConverter.parseDateTime((String)toParse);
        }
        return DatatypeConverter.parseDateTime((String)dateString);
    }
}

