/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.namesrv.RegisterBrokerResult;
import org.apache.rocketmq.common.protocol.body.RegisterBrokerBody;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.protocol.header.GetTopicsByClusterRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.DeleteKVConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.DeleteTopicInNamesrvRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.GetKVConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.GetKVConfigResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.GetKVListByNamespaceRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.GetRouteInfoRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.PutKVConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.QueryDataVersionRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.QueryDataVersionResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.RegisterBrokerRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.RegisterBrokerResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.UnRegisterBrokerRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.WipeWritePermOfBrokerRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.WipeWritePermOfBrokerResponseHeader;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.AsyncNettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class DefaultRequestProcessor
extends AsyncNettyRequestProcessor
implements NettyRequestProcessor {
    private static InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqNamesrv");
    protected final NamesrvController namesrvController;

    public DefaultRequestProcessor(NamesrvController namesrvController) {
        this.namesrvController = namesrvController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        if (ctx != null) {
            log.debug("receive request, {} {} {}", new Object[]{request.getCode(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), request});
        }
        switch (request.getCode()) {
            case 100: {
                return this.putKVConfig(ctx, request);
            }
            case 101: {
                return this.getKVConfig(ctx, request);
            }
            case 102: {
                return this.deleteKVConfig(ctx, request);
            }
            case 322: {
                return this.queryBrokerTopicConfig(ctx, request);
            }
            case 103: {
                MQVersion.Version brokerVersion = MQVersion.value2Version((int)request.getVersion());
                if (brokerVersion.ordinal() >= MQVersion.Version.V3_0_11.ordinal()) {
                    return this.registerBrokerWithFilterServer(ctx, request);
                }
                return this.registerBroker(ctx, request);
            }
            case 104: {
                return this.unregisterBroker(ctx, request);
            }
            case 105: {
                return this.getRouteInfoByTopic(ctx, request);
            }
            case 106: {
                return this.getBrokerClusterInfo(ctx, request);
            }
            case 205: {
                return this.wipeWritePermOfBroker(ctx, request);
            }
            case 206: {
                return this.getAllTopicListFromNameserver(ctx, request);
            }
            case 216: {
                return this.deleteTopicInNamesrv(ctx, request);
            }
            case 219: {
                return this.getKVListByNamespace(ctx, request);
            }
            case 224: {
                return this.getTopicsByCluster(ctx, request);
            }
            case 304: {
                return this.getSystemTopicListFromNs(ctx, request);
            }
            case 311: {
                return this.getUnitTopicList(ctx, request);
            }
            case 312: {
                return this.getHasUnitSubTopicList(ctx, request);
            }
            case 313: {
                return this.getHasUnitSubUnUnitTopicList(ctx, request);
            }
            case 318: {
                return this.updateConfig(ctx, request);
            }
            case 319: {
                return this.getConfig(ctx, request);
            }
        }
        return null;
    }

    public boolean rejectRequest() {
        return false;
    }

    public RemotingCommand putKVConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        PutKVConfigRequestHeader requestHeader = (PutKVConfigRequestHeader)request.decodeCommandCustomHeader(PutKVConfigRequestHeader.class);
        this.namesrvController.getKvConfigManager().putKVConfig(requestHeader.getNamespace(), requestHeader.getKey(), requestHeader.getValue());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand getKVConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetKVConfigResponseHeader.class);
        GetKVConfigResponseHeader responseHeader = (GetKVConfigResponseHeader)response.readCustomHeader();
        GetKVConfigRequestHeader requestHeader = (GetKVConfigRequestHeader)request.decodeCommandCustomHeader(GetKVConfigRequestHeader.class);
        String value = this.namesrvController.getKvConfigManager().getKVConfig(requestHeader.getNamespace(), requestHeader.getKey());
        if (value != null) {
            responseHeader.setValue(value);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(22);
        response.setRemark("No config item, Namespace: " + requestHeader.getNamespace() + " Key: " + requestHeader.getKey());
        return response;
    }

    public RemotingCommand deleteKVConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        DeleteKVConfigRequestHeader requestHeader = (DeleteKVConfigRequestHeader)request.decodeCommandCustomHeader(DeleteKVConfigRequestHeader.class);
        this.namesrvController.getKvConfigManager().deleteKVConfig(requestHeader.getNamespace(), requestHeader.getKey());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand registerBrokerWithFilterServer(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(RegisterBrokerResponseHeader.class);
        RegisterBrokerResponseHeader responseHeader = (RegisterBrokerResponseHeader)response.readCustomHeader();
        RegisterBrokerRequestHeader requestHeader = (RegisterBrokerRequestHeader)request.decodeCommandCustomHeader(RegisterBrokerRequestHeader.class);
        if (!this.checksum(ctx, request, requestHeader)) {
            response.setCode(1);
            response.setRemark("crc32 not match");
            return response;
        }
        RegisterBrokerBody registerBrokerBody = new RegisterBrokerBody();
        if (request.getBody() != null) {
            try {
                registerBrokerBody = RegisterBrokerBody.decode((byte[])request.getBody(), (boolean)requestHeader.isCompressed());
            }
            catch (Exception e) {
                throw new RemotingCommandException("Failed to decode RegisterBrokerBody", (Throwable)e);
            }
        } else {
            registerBrokerBody.getTopicConfigSerializeWrapper().getDataVersion().setCounter(new AtomicLong(0L));
            registerBrokerBody.getTopicConfigSerializeWrapper().getDataVersion().setTimestamp(0L);
        }
        RegisterBrokerResult result = this.namesrvController.getRouteInfoManager().registerBroker(requestHeader.getClusterName(), requestHeader.getBrokerAddr(), requestHeader.getBrokerName(), requestHeader.getBrokerId(), requestHeader.getHaServerAddr(), registerBrokerBody.getTopicConfigSerializeWrapper(), registerBrokerBody.getFilterServerList(), ctx.channel());
        responseHeader.setHaServerAddr(result.getHaServerAddr());
        responseHeader.setMasterAddr(result.getMasterAddr());
        byte[] jsonValue = this.namesrvController.getKvConfigManager().getKVListByNamespace("ORDER_TOPIC_CONFIG");
        response.setBody(jsonValue);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private boolean checksum(ChannelHandlerContext ctx, RemotingCommand request, RegisterBrokerRequestHeader requestHeader) {
        int crc32;
        if (requestHeader.getBodyCrc32() != 0 && (crc32 = UtilAll.crc32((byte[])request.getBody())) != requestHeader.getBodyCrc32()) {
            log.warn(String.format("receive registerBroker request,crc32 not match,from %s", RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel())));
            return false;
        }
        return true;
    }

    public RemotingCommand queryBrokerTopicConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(QueryDataVersionResponseHeader.class);
        QueryDataVersionResponseHeader responseHeader = (QueryDataVersionResponseHeader)response.readCustomHeader();
        QueryDataVersionRequestHeader requestHeader = (QueryDataVersionRequestHeader)request.decodeCommandCustomHeader(QueryDataVersionRequestHeader.class);
        DataVersion dataVersion = (DataVersion)DataVersion.decode((byte[])request.getBody(), DataVersion.class);
        Boolean changed = this.namesrvController.getRouteInfoManager().isBrokerTopicConfigChanged(requestHeader.getBrokerAddr(), dataVersion);
        if (!changed.booleanValue()) {
            this.namesrvController.getRouteInfoManager().updateBrokerInfoUpdateTimestamp(requestHeader.getBrokerAddr());
        }
        DataVersion nameSeverDataVersion = this.namesrvController.getRouteInfoManager().queryBrokerTopicConfig(requestHeader.getBrokerAddr());
        response.setCode(0);
        response.setRemark(null);
        if (nameSeverDataVersion != null) {
            response.setBody(nameSeverDataVersion.encode());
        }
        responseHeader.setChanged(changed);
        return response;
    }

    public RemotingCommand registerBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        TopicConfigSerializeWrapper topicConfigWrapper;
        RemotingCommand response = RemotingCommand.createResponseCommand(RegisterBrokerResponseHeader.class);
        RegisterBrokerResponseHeader responseHeader = (RegisterBrokerResponseHeader)response.readCustomHeader();
        RegisterBrokerRequestHeader requestHeader = (RegisterBrokerRequestHeader)request.decodeCommandCustomHeader(RegisterBrokerRequestHeader.class);
        if (!this.checksum(ctx, request, requestHeader)) {
            response.setCode(1);
            response.setRemark("crc32 not match");
            return response;
        }
        if (request.getBody() != null) {
            topicConfigWrapper = (TopicConfigSerializeWrapper)TopicConfigSerializeWrapper.decode((byte[])request.getBody(), TopicConfigSerializeWrapper.class);
        } else {
            topicConfigWrapper = new TopicConfigSerializeWrapper();
            topicConfigWrapper.getDataVersion().setCounter(new AtomicLong(0L));
            topicConfigWrapper.getDataVersion().setTimestamp(0L);
        }
        RegisterBrokerResult result = this.namesrvController.getRouteInfoManager().registerBroker(requestHeader.getClusterName(), requestHeader.getBrokerAddr(), requestHeader.getBrokerName(), requestHeader.getBrokerId(), requestHeader.getHaServerAddr(), topicConfigWrapper, null, ctx.channel());
        responseHeader.setHaServerAddr(result.getHaServerAddr());
        responseHeader.setMasterAddr(result.getMasterAddr());
        byte[] jsonValue = this.namesrvController.getKvConfigManager().getKVListByNamespace("ORDER_TOPIC_CONFIG");
        response.setBody(jsonValue);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand unregisterBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        UnRegisterBrokerRequestHeader requestHeader = (UnRegisterBrokerRequestHeader)request.decodeCommandCustomHeader(UnRegisterBrokerRequestHeader.class);
        this.namesrvController.getRouteInfoManager().unregisterBroker(requestHeader.getClusterName(), requestHeader.getBrokerAddr(), requestHeader.getBrokerName(), requestHeader.getBrokerId());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand getRouteInfoByTopic(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetRouteInfoRequestHeader requestHeader = (GetRouteInfoRequestHeader)request.decodeCommandCustomHeader(GetRouteInfoRequestHeader.class);
        TopicRouteData topicRouteData = this.namesrvController.getRouteInfoManager().pickupTopicRouteData(requestHeader.getTopic());
        if (topicRouteData != null) {
            if (this.namesrvController.getNamesrvConfig().isOrderMessageEnable()) {
                String orderTopicConf = this.namesrvController.getKvConfigManager().getKVConfig("ORDER_TOPIC_CONFIG", requestHeader.getTopic());
                topicRouteData.setOrderTopicConf(orderTopicConf);
            }
            byte[] content = topicRouteData.encode();
            response.setBody(content);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(17);
        response.setRemark("No topic route info in name server for the topic: " + requestHeader.getTopic() + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"));
        return response;
    }

    private RemotingCommand getBrokerClusterInfo(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] content = this.namesrvController.getRouteInfoManager().getAllClusterInfo();
        response.setBody(content);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand wipeWritePermOfBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(WipeWritePermOfBrokerResponseHeader.class);
        WipeWritePermOfBrokerResponseHeader responseHeader = (WipeWritePermOfBrokerResponseHeader)response.readCustomHeader();
        WipeWritePermOfBrokerRequestHeader requestHeader = (WipeWritePermOfBrokerRequestHeader)request.decodeCommandCustomHeader(WipeWritePermOfBrokerRequestHeader.class);
        int wipeTopicCnt = this.namesrvController.getRouteInfoManager().wipeWritePermOfBrokerByLock(requestHeader.getBrokerName());
        if (ctx != null) {
            log.info("wipe write perm of broker[{}], client: {}, {}", new Object[]{requestHeader.getBrokerName(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), wipeTopicCnt});
        }
        responseHeader.setWipeTopicCount(Integer.valueOf(wipeTopicCnt));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getAllTopicListFromNameserver(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] body = this.namesrvController.getRouteInfoManager().getAllTopicList();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand deleteTopicInNamesrv(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        DeleteTopicInNamesrvRequestHeader requestHeader = (DeleteTopicInNamesrvRequestHeader)request.decodeCommandCustomHeader(DeleteTopicInNamesrvRequestHeader.class);
        this.namesrvController.getRouteInfoManager().deleteTopic(requestHeader.getTopic());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getKVListByNamespace(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetKVListByNamespaceRequestHeader requestHeader = (GetKVListByNamespaceRequestHeader)request.decodeCommandCustomHeader(GetKVListByNamespaceRequestHeader.class);
        byte[] jsonValue = this.namesrvController.getKvConfigManager().getKVListByNamespace(requestHeader.getNamespace());
        if (null != jsonValue) {
            response.setBody(jsonValue);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(22);
        response.setRemark("No config item, Namespace: " + requestHeader.getNamespace());
        return response;
    }

    private RemotingCommand getTopicsByCluster(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetTopicsByClusterRequestHeader requestHeader = (GetTopicsByClusterRequestHeader)request.decodeCommandCustomHeader(GetTopicsByClusterRequestHeader.class);
        byte[] body = this.namesrvController.getRouteInfoManager().getTopicsByCluster(requestHeader.getCluster());
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getSystemTopicListFromNs(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] body = this.namesrvController.getRouteInfoManager().getSystemTopicList();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getUnitTopicList(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] body = this.namesrvController.getRouteInfoManager().getUnitTopics();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getHasUnitSubTopicList(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] body = this.namesrvController.getRouteInfoManager().getHasUnitSubTopicList();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getHasUnitSubUnUnitTopicList(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] body = this.namesrvController.getRouteInfoManager().getHasUnitSubUnUnitTopicList();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand updateConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        if (ctx != null) {
            log.info("updateConfig called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        }
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] body = request.getBody();
        if (body != null) {
            String bodyStr;
            try {
                bodyStr = new String(body, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("updateConfig byte array to string error: ", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
            Properties properties = MixAll.string2Properties((String)bodyStr);
            if (properties == null) {
                log.error("updateConfig MixAll.string2Properties error {}", (Object)bodyStr);
                response.setCode(1);
                response.setRemark("string2Properties error");
                return response;
            }
            this.namesrvController.getConfiguration().update(properties);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        String content = this.namesrvController.getConfiguration().getAllConfigsFormatString();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("getConfig error, ", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }
}

