/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.AbstractRestObjectMapper;

public class RestObjectMapper
extends AbstractRestObjectMapper {
    private static final long serialVersionUID = -8158869347066287575L;
    private static final JavaType STRING_JAVA_TYPE = TypeFactory.defaultInstance().constructType(String.class);

    public RestObjectMapper() {
        this.getFactory().disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
        this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.enable(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        this.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, (JsonSerializer)new JsonObjectSerializer());
        this.registerModule((Module)module);
        this.registerModule((Module)new JavaTimeModule());
    }

    @Override
    public String convertToString(Object value) throws Exception {
        return (String)this.convertValue(value, STRING_JAVA_TYPE);
    }

    public <T> T convertValue(Object fromValue, JavaType toValueType) throws IllegalArgumentException {
        if (fromValue == null) {
            return null;
        }
        Class targetType = toValueType.getRawClass();
        if (targetType != Object.class && !toValueType.hasGenericTypes() && targetType.isAssignableFrom(fromValue.getClass())) {
            return (T)fromValue;
        }
        return (T)super.convertValue(fromValue, toValueType);
    }

    private static class JsonObjectSerializer
    extends JsonSerializer<JsonObject> {
        private JsonObjectSerializer() {
        }

        public void serialize(JsonObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject((Object)value.getMap());
        }
    }
}

