/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import io.protostuff.runtime.ProtobufFeature;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import org.apache.servicecomb.foundation.vertx.client.tcp.AbstractTcpClientPackage;
import org.apache.servicecomb.foundation.vertx.client.tcp.NetClientWrapper;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpClientConnection;
import org.apache.servicecomb.foundation.vertx.tcp.TcpOutputStream;
import org.apache.servicecomb.transport.highway.HighwayOutputStream;
import org.apache.servicecomb.transport.highway.message.LoginRequest;
import org.apache.servicecomb.transport.highway.message.LoginResponse;
import org.apache.servicecomb.transport.highway.message.RequestHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighwayClientConnection
extends TcpClientConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayClientConnection.class);
    private ProtobufFeature protobufFeature = new ProtobufFeature();

    public HighwayClientConnection(Context context, NetClientWrapper netClientWrapper, String endpoint) {
        super(context, netClientWrapper, endpoint);
        this.setLocalSupportLogin(true);
    }

    public ProtobufFeature getProtobufFeature() {
        return this.protobufFeature;
    }

    protected TcpOutputStream createLogin() {
        try {
            RequestHeader header = new RequestHeader();
            header.setMsgType((byte)1);
            LoginRequest login = new LoginRequest();
            login.setProtocol("highway");
            login.setUseProtobufMapCodec(true);
            HighwayOutputStream os = new HighwayOutputStream(AbstractTcpClientPackage.getAndIncRequestId(), null);
            os.write(header, LoginRequest.getLoginRequestSchema(), (Object)login);
            return os;
        }
        catch (Throwable e) {
            throw new Error("impossible.", e);
        }
    }

    protected boolean onLoginResponse(Buffer bodyBuffer) {
        try {
            LoginResponse response = LoginResponse.readObject(bodyBuffer);
            this.protobufFeature.setUseProtobufMapCodec(response.isUseProtobufMapCodec());
            return true;
        }
        catch (Throwable e) {
            LOGGER.error("decode login response failed.", e);
            return false;
        }
    }
}

