/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import io.protostuff.runtime.ProtobufFeature;
import io.vertx.core.buffer.Buffer;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.utils.WrapSchema;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpData;
import org.apache.servicecomb.foundation.vertx.tcp.TcpOutputStream;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.transport.highway.HighwayOutputStream;
import org.apache.servicecomb.transport.highway.message.RequestHeader;
import org.apache.servicecomb.transport.highway.message.ResponseHeader;

public final class HighwayCodec {
    private HighwayCodec() {
    }

    public static TcpOutputStream encodeRequest(long msgId, Invocation invocation, OperationProtobuf operationProtobuf, ProtobufFeature protobufFeature) throws Exception {
        RequestHeader header = new RequestHeader();
        header.setMsgType((byte)0);
        header.setFlags(0);
        header.setDestMicroservice(invocation.getMicroserviceName());
        header.setSchemaId(invocation.getSchemaId());
        header.setOperationName(invocation.getOperationName());
        header.setContext(invocation.getContext());
        HighwayOutputStream os = new HighwayOutputStream(msgId, protobufFeature);
        os.write(header, operationProtobuf.getRequestSchema(), (Object)invocation.getArgs());
        return os;
    }

    public static void decodeRequest(Invocation invocation, RequestHeader header, OperationProtobuf operationProtobuf, Buffer bodyBuffer, ProtobufFeature protobufFeature) throws Exception {
        WrapSchema schema = operationProtobuf.getRequestSchema();
        Object[] args = (Object[])schema.readObject(bodyBuffer, protobufFeature);
        invocation.setSwaggerArguments(args);
        invocation.setContext(header.getContext());
    }

    public static RequestHeader readRequestHeader(Buffer headerBuffer, ProtobufFeature protobufFeature) throws Exception {
        return RequestHeader.readObject(headerBuffer, protobufFeature);
    }

    public static Buffer encodeResponse(long msgId, ResponseHeader header, WrapSchema bodySchema, Object body, ProtobufFeature protobufFeature) throws Exception {
        try (HighwayOutputStream os = new HighwayOutputStream(msgId, protobufFeature);){
            os.write(header, bodySchema, body);
            Buffer buffer = os.getBuffer();
            return buffer;
        }
    }

    public static Response decodeResponse(Invocation invocation, OperationProtobuf operationProtobuf, TcpData tcpData, ProtobufFeature protobufFeature) throws Exception {
        ResponseHeader header = ResponseHeader.readObject(tcpData.getHeaderBuffer(), protobufFeature);
        if (header.getContext() != null) {
            invocation.getContext().putAll(header.getContext());
        }
        WrapSchema bodySchema = operationProtobuf.findResponseSchema(header.getStatusCode());
        Object body = bodySchema.readObject(tcpData.getBodyBuffer(), protobufFeature);
        Response response = Response.create((int)header.getStatusCode(), (String)header.getReasonPhrase(), (Object)body);
        response.setHeaders(header.getHeaders());
        return response;
    }
}

