/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import io.protostuff.runtime.ProtobufFeature;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetSocket;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.foundation.vertx.server.TcpBufferHandler;
import org.apache.servicecomb.foundation.vertx.server.TcpParser;
import org.apache.servicecomb.foundation.vertx.server.TcpServerConnection;
import org.apache.servicecomb.foundation.vertx.tcp.TcpConnection;
import org.apache.servicecomb.transport.highway.HighwayCodec;
import org.apache.servicecomb.transport.highway.HighwayOutputStream;
import org.apache.servicecomb.transport.highway.HighwayServerInvoke;
import org.apache.servicecomb.transport.highway.message.LoginRequest;
import org.apache.servicecomb.transport.highway.message.LoginResponse;
import org.apache.servicecomb.transport.highway.message.RequestHeader;
import org.apache.servicecomb.transport.highway.message.ResponseHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighwayServerConnection
extends TcpServerConnection
implements TcpBufferHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayServerConnection.class);
    private Endpoint endpoint;
    private ProtobufFeature protobufFeature = new ProtobufFeature();

    public HighwayServerConnection(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void init(NetSocket netSocket) {
        this.splitter = new TcpParser((TcpBufferHandler)this);
        super.init(netSocket);
    }

    public void handle(long msgId, Buffer headerBuffer, Buffer bodyBuffer) {
        RequestHeader requestHeader = this.decodeRequestHeader(msgId, headerBuffer);
        if (requestHeader == null) {
            return;
        }
        switch (requestHeader.getMsgType()) {
            case 0: {
                this.onRequest(msgId, requestHeader, bodyBuffer);
                break;
            }
            case 1: {
                this.onLogin(msgId, requestHeader, bodyBuffer);
                break;
            }
            default: {
                throw new Error("Unknown tcp msgType " + requestHeader.getMsgType());
            }
        }
    }

    protected RequestHeader decodeRequestHeader(long msgId, Buffer headerBuffer) {
        RequestHeader requestHeader = null;
        try {
            requestHeader = HighwayCodec.readRequestHeader(headerBuffer, this.protobufFeature);
        }
        catch (Exception e) {
            String msg = String.format("decode request header error, msgId=%d", msgId);
            LOGGER.error(msg, (Throwable)e);
            this.netSocket.close();
            return null;
        }
        return requestHeader;
    }

    protected void onLogin(long msgId, RequestHeader header, Buffer bodyBuffer) {
        LoginRequest request = null;
        try {
            request = LoginRequest.readObject(bodyBuffer);
        }
        catch (Exception e) {
            String msg = String.format("decode setParameter error, msgId=%d", msgId);
            LOGGER.error(msg, (Throwable)e);
            this.netSocket.close();
            return;
        }
        if (request != null) {
            this.setProtocol(request.getProtocol());
            this.setZipName(request.getZipName());
            this.protobufFeature.setUseProtobufMapCodec(request.isUseProtobufMapCodec());
        }
        try (HighwayOutputStream os = new HighwayOutputStream(msgId, this.protobufFeature);){
            ResponseHeader responseHeader = new ResponseHeader();
            responseHeader.setStatusCode(Response.Status.OK.getStatusCode());
            LoginResponse response = new LoginResponse();
            response.setUseProtobufMapCodec(this.protobufFeature.isUseProtobufMapCodec());
            os.write(ResponseHeader.getResponseHeaderSchema(), responseHeader, LoginResponse.getLoginResponseSchema(), response);
            this.netSocket.write(os.getBuffer());
        }
        catch (Exception e) {
            throw new Error("impossible.", e);
        }
    }

    protected void onRequest(long msgId, RequestHeader header, Buffer bodyBuffer) {
        HighwayServerInvoke invoke = new HighwayServerInvoke(this.endpoint, this.protobufFeature);
        if (invoke.init((TcpConnection)this, msgId, header, bodyBuffer)) {
            invoke.execute();
        }
    }
}

