/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import io.protostuff.runtime.ProtobufFeature;
import io.vertx.core.buffer.Buffer;
import java.util.Map;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.definition.ProtobufManager;
import org.apache.servicecomb.codec.protobuf.utils.WrapSchema;
import org.apache.servicecomb.core.CseContext;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceMetaManager;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.foundation.vertx.tcp.TcpConnection;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.highway.HighwayCodec;
import org.apache.servicecomb.transport.highway.message.RequestHeader;
import org.apache.servicecomb.transport.highway.message.ResponseHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighwayServerInvoke {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayServerInvoke.class);
    private MicroserviceMetaManager microserviceMetaManager = CseContext.getInstance().getMicroserviceMetaManager();
    private ProtobufFeature protobufFeature;
    private RequestHeader header;
    private OperationMeta operationMeta;
    private OperationProtobuf operationProtobuf;
    private TcpConnection connection;
    private long msgId;
    private Buffer bodyBuffer;
    private Endpoint endpoint;
    Invocation invocation;

    public HighwayServerInvoke() {
        this(null, null);
    }

    public HighwayServerInvoke(Endpoint endpoint, ProtobufFeature protobufFeature) {
        this.endpoint = endpoint;
        this.protobufFeature = protobufFeature;
    }

    public void setMicroserviceMetaManager(MicroserviceMetaManager microserviceMetaManager) {
        this.microserviceMetaManager = microserviceMetaManager;
    }

    public boolean init(TcpConnection connection, long msgId, RequestHeader header, Buffer bodyBuffer) {
        try {
            this.doInit(connection, msgId, header, bodyBuffer);
            return true;
        }
        catch (Throwable e) {
            String microserviceQualifiedName = "unknown";
            if (this.operationMeta != null) {
                microserviceQualifiedName = this.operationMeta.getMicroserviceQualifiedName();
            }
            String msg = String.format("decode request error, microserviceQualifiedName=%s, msgId=%d", microserviceQualifiedName, msgId);
            LOGGER.error(msg, e);
            return false;
        }
    }

    private void doInit(TcpConnection connection, long msgId, RequestHeader header, Buffer bodyBuffer) throws Exception {
        this.connection = connection;
        this.msgId = msgId;
        this.header = header;
        MicroserviceMeta microserviceMeta = (MicroserviceMeta)this.microserviceMetaManager.ensureFindValue((Object)header.getDestMicroservice());
        SchemaMeta schemaMeta = microserviceMeta.ensureFindSchemaMeta(header.getSchemaId());
        this.operationMeta = (OperationMeta)schemaMeta.ensureFindOperation(header.getOperationName());
        this.operationProtobuf = ProtobufManager.getOrCreateOperation((OperationMeta)this.operationMeta);
        this.bodyBuffer = bodyBuffer;
    }

    private void runInExecutor() {
        try {
            this.doRunInExecutor();
        }
        catch (Throwable e) {
            String msg = String.format("handle request error, %s, msgId=%d", this.operationMeta.getMicroserviceQualifiedName(), this.msgId);
            LOGGER.error(msg, e);
            this.sendResponse(this.header.getContext(), Response.providerFailResp((Throwable)e));
        }
    }

    private void doRunInExecutor() throws Exception {
        this.invocation.onStartExecute();
        HighwayCodec.decodeRequest(this.invocation, this.header, this.operationProtobuf, this.bodyBuffer, this.protobufFeature);
        this.invocation.getHandlerContext().put("x-cse-remote-address", this.connection.getNetSocket().remoteAddress());
        this.invocation.next(response -> this.sendResponse(this.invocation.getContext(), response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(Map<String, String> context, Response response) {
        ResponseHeader header = new ResponseHeader();
        header.setStatusCode(response.getStatusCode());
        header.setReasonPhrase(response.getReasonPhrase());
        header.setContext(context);
        header.setHeaders(response.getHeaders());
        WrapSchema bodySchema = this.operationProtobuf.findResponseSchema(response.getStatusCode());
        Object body = response.getResult();
        if (response.isFailed()) {
            body = ((InvocationException)body).getErrorData();
        }
        try {
            Buffer respBuffer = HighwayCodec.encodeResponse(this.msgId, header, bodySchema, body, this.protobufFeature);
            this.connection.write(respBuffer.getByteBuf());
        }
        catch (Exception e) {
            String msg = String.format("encode response failed, %s, msgId=%d", this.operationProtobuf.getOperationMeta().getMicroserviceQualifiedName(), this.msgId);
            LOGGER.error(msg, (Throwable)e);
        }
        finally {
            if (this.invocation != null) {
                this.invocation.onFinish(response);
            }
        }
    }

    public void execute() {
        try {
            this.invocation = InvocationFactory.forProvider((Endpoint)this.endpoint, (OperationMeta)this.operationProtobuf.getOperationMeta(), null);
            this.invocation.onStart();
            this.operationMeta.getExecutor().execute(() -> this.runInExecutor());
        }
        catch (IllegalStateException e) {
            this.sendResponse(this.header.getContext(), Response.providerFailResp((Throwable)e));
        }
    }
}

