/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.net.InetSocketAddress;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.transport.highway.HighwayServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighwayServerVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayServerVerticle.class);
    public static final String SSL_KEY = "highway.provider";
    private Endpoint endpoint;
    private URIEndpointObject endpointObject;

    public void init(Vertx vertx, Context context) {
        super.init(vertx, context);
        this.endpoint = (Endpoint)context.config().getValue("cse.endpoint");
        this.endpointObject = (URIEndpointObject)this.endpoint.getAddress();
    }

    public void start(Future<Void> startFuture) throws Exception {
        try {
            super.start();
            this.startListen(startFuture);
        }
        catch (Throwable e) {
            LOGGER.error("", e);
            throw e;
        }
    }

    protected void startListen(Future<Void> startFuture) {
        if (this.endpointObject == null) {
            LOGGER.warn("highway listen address is not configured, will not listen.");
            startFuture.complete();
            return;
        }
        HighwayServer server = new HighwayServer(this.endpoint);
        server.init(this.vertx, SSL_KEY, ar -> {
            if (ar.succeeded()) {
                InetSocketAddress socketAddress = (InetSocketAddress)ar.result();
                LOGGER.info("highway listen success. address={}:{}", (Object)socketAddress.getHostString(), (Object)socketAddress.getPort());
                startFuture.complete();
                return;
            }
            LOGGER.error("highway", ar.cause());
            startFuture.fail(ar.cause());
        });
    }
}

