/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;

public final class DropDatabaseDiscoveryRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropDatabaseDiscoveryRuleStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "database discovery";

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkIsExist(schemaName, sqlStatement, currentRuleConfig);
        this.checkIsInUse(schemaName, sqlStatement, shardingSphereMetaData);
    }

    private void checkCurrentRuleConfiguration(String schemaName, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, (DistSQLException)new RequiredRuleMissedException("Database discovery", schemaName));
    }

    private void checkIsExist(String schemaName, DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection currentRuleNames = currentRuleConfig.getDataSources().stream().map(DatabaseDiscoveryDataSourceRuleConfiguration::getGroupName).collect(Collectors.toList());
        Collection notExistedRuleNames = sqlStatement.getRuleNames().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedRuleNames.isEmpty(), (DistSQLException)new RequiredRuleMissedException(RULE_TYPE, schemaName));
    }

    private void checkIsInUse(String schemaName, DropDatabaseDiscoveryRuleStatement sqlStatement, ShardingSphereMetaData shardingSphereMetaData) throws DistSQLException {
        Collection rulesInUse = shardingSphereMetaData.getRuleMetaData().findRules(ExportableRule.class).stream().filter(each -> each.containExportableKey(Collections.singletonList("auto_aware_data_source_name"))).map(each -> each.export("auto_aware_data_source_name")).filter(Optional::isPresent).map(each -> (Collection)each.get()).flatMap(Collection::stream).collect(Collectors.toSet());
        Collection invalid = sqlStatement.getRuleNames().stream().filter(rulesInUse::contains).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalid.isEmpty(), (DistSQLException)new RuleInUsedException(RULE_TYPE, schemaName, invalid));
    }

    public boolean updateCurrentRuleConfiguration(DropDatabaseDiscoveryRuleStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getRuleNames()) {
            this.dropRule(currentRuleConfig, each);
        }
        return false;
    }

    private void dropRule(DatabaseDiscoveryRuleConfiguration currentRuleConfig, String ruleName) {
        Optional<DatabaseDiscoveryDataSourceRuleConfiguration> dataSourceRuleConfig = currentRuleConfig.getDataSources().stream().filter(dataSource -> dataSource.getGroupName().equals(ruleName)).findAny();
        Preconditions.checkState((boolean)dataSourceRuleConfig.isPresent());
        currentRuleConfig.getDataSources().remove(dataSourceRuleConfig.get());
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return DropDatabaseDiscoveryRuleStatement.class.getName();
    }
}

