/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.core.kernel;

import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.KernelDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.KernelDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.parser.segment.CacheOptionSegment;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.HostnameAndPortBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.MigrationProcessConfigurationSegment;
import org.apache.shardingsphere.distsql.parser.segment.ReadOrWriteSegment;
import org.apache.shardingsphere.distsql.parser.segment.TransactionProviderSegment;
import org.apache.shardingsphere.distsql.parser.segment.URLBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.parser.statement.ral.hint.ClearHintStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ConvertYamlConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ExportDatabaseConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowAllVariablesStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowInstanceInfoStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowInstanceListStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowMigrationProcessConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowModeInfoStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowSQLParserRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowSQLTranslatorRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowTableMetadataStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowTransactionRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ShowVariableStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.AlterInstanceStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.AlterMigrationProcessConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.AlterSQLParserRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.AlterTransactionRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.ApplyDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.CreateMigrationProcessConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.DiscardDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.DropMigrationProcessConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.ImportDatabaseConfigurationStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.LabelInstanceStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.PrepareDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.RefreshTableMetadataStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.SetInstanceStatusStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.SetVariableStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.updatable.UnlabelInstanceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AddResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.CreateDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.CountDatabaseRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.CountSingleTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowResourcesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowRulesUsedResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowUnusedResourcesStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class KernelDistSQLStatementVisitor
extends KernelDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitAddResource(KernelDistSQLStatementParser.AddResourceContext ctx) {
        return new AddResourceStatement((Collection)ctx.resourceDefinition().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterResource(KernelDistSQLStatementParser.AlterResourceContext ctx) {
        return new AlterResourceStatement((Collection)ctx.resourceDefinition().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowTableMetadata(KernelDistSQLStatementParser.ShowTableMetadataContext ctx) {
        Collection tableNames = ctx.tableName().stream().map(this::getIdentifierValue).collect(Collectors.toSet());
        return new ShowTableMetadataStatement(tableNames, null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitResourceDefinition(KernelDistSQLStatementParser.ResourceDefinitionContext ctx) {
        String user = this.getIdentifierValue((ParseTree)ctx.user());
        String password = null == ctx.password() ? "" : this.getPassword(ctx.password());
        Properties props = this.getProperties(ctx.propertiesDefinition());
        URLBasedDataSourceSegment result = null;
        if (null != ctx.urlSource()) {
            result = new URLBasedDataSourceSegment(this.getIdentifierValue((ParseTree)ctx.resourceName()), this.getIdentifierValue((ParseTree)ctx.urlSource().url()), user, password, props);
        }
        if (null != ctx.simpleSource()) {
            result = new HostnameAndPortBasedDataSourceSegment(this.getIdentifierValue((ParseTree)ctx.resourceName()), this.getIdentifierValue((ParseTree)ctx.simpleSource().hostname()), ctx.simpleSource().port().getText(), this.getIdentifierValue((ParseTree)ctx.simpleSource().dbName()), user, password, props);
        }
        return result;
    }

    private String getPassword(KernelDistSQLStatementParser.PasswordContext ctx) {
        return this.getIdentifierValue((ParseTree)ctx);
    }

    @Override
    public ASTNode visitShowInstanceList(KernelDistSQLStatementParser.ShowInstanceListContext ctx) {
        return new ShowInstanceListStatement();
    }

    @Override
    public ASTNode visitShowInstanceInfo(KernelDistSQLStatementParser.ShowInstanceInfoContext ctx) {
        return new ShowInstanceInfoStatement();
    }

    @Override
    public ASTNode visitShowModeInfo(KernelDistSQLStatementParser.ShowModeInfoContext ctx) {
        return new ShowModeInfoStatement();
    }

    @Override
    public ASTNode visitEnableInstance(KernelDistSQLStatementParser.EnableInstanceContext ctx) {
        return this.buildSetInstanceStatusStatement(ctx.ENABLE().getText().toUpperCase(), ctx.instanceId());
    }

    @Override
    public ASTNode visitDisableInstance(KernelDistSQLStatementParser.DisableInstanceContext ctx) {
        return this.buildSetInstanceStatusStatement(ctx.DISABLE().getText().toUpperCase(), ctx.instanceId());
    }

    @Override
    public ASTNode visitLabelInstance(KernelDistSQLStatementParser.LabelInstanceContext ctx) {
        Collection labels = ctx.label().stream().map(this::getIdentifierValue).collect(Collectors.toList());
        return new LabelInstanceStatement(ctx.RELABEL() != null, this.getIdentifierValue((ParseTree)ctx.instanceId()), labels);
    }

    @Override
    public ASTNode visitUnlabelInstance(KernelDistSQLStatementParser.UnlabelInstanceContext ctx) {
        Collection labels = ctx.label().stream().map(this::getIdentifierValue).collect(Collectors.toList());
        return new UnlabelInstanceStatement(this.getIdentifierValue((ParseTree)ctx.instanceId()), labels);
    }

    private SetInstanceStatusStatement buildSetInstanceStatusStatement(String status, KernelDistSQLStatementParser.InstanceIdContext instanceIdContext) {
        return new SetInstanceStatusStatement(status, this.getIdentifierValue((ParseTree)instanceIdContext));
    }

    @Override
    public ASTNode visitCountSingleTableRule(KernelDistSQLStatementParser.CountSingleTableRuleContext ctx) {
        return new CountSingleTableRuleStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitAlterInstance(KernelDistSQLStatementParser.AlterInstanceContext ctx) {
        return new AlterInstanceStatement(this.getIdentifierValue((ParseTree)ctx.instanceId()), this.getIdentifierValue((ParseTree)ctx.variableName()), this.getIdentifierValue((ParseTree)ctx.variableValues()));
    }

    @Override
    public ASTNode visitCountDatabaseRules(KernelDistSQLStatementParser.CountDatabaseRulesContext ctx) {
        return new CountDatabaseRulesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitCreateDefaultSingleTableRule(KernelDistSQLStatementParser.CreateDefaultSingleTableRuleContext ctx) {
        return new CreateDefaultSingleTableRuleStatement(this.getIdentifierValue((ParseTree)ctx.resourceName()));
    }

    @Override
    public ASTNode visitAlterDefaultSingleTableRule(KernelDistSQLStatementParser.AlterDefaultSingleTableRuleContext ctx) {
        return new AlterDefaultSingleTableRuleStatement(this.getIdentifierValue((ParseTree)ctx.resourceName()));
    }

    @Override
    public ASTNode visitDropDefaultSingleTableRule(KernelDistSQLStatementParser.DropDefaultSingleTableRuleContext ctx) {
        return new DropDefaultSingleTableRuleStatement(null != ctx.ifExists());
    }

    private Properties getProperties(KernelDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (KernelDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitDropResource(KernelDistSQLStatementParser.DropResourceContext ctx) {
        boolean ignoreSingleTables = null != ctx.ignoreSingleTables();
        return new DropResourceStatement(ctx.ifExists() != null, (Collection)ctx.resourceName().stream().map(ParseTree::getText).map(each -> new IdentifierValue(each).getValue()).collect(Collectors.toList()), ignoreSingleTables);
    }

    @Override
    public ASTNode visitShowResources(KernelDistSQLStatementParser.ShowResourcesContext ctx) {
        return new ShowResourcesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowUnusedResources(KernelDistSQLStatementParser.ShowUnusedResourcesContext ctx) {
        return new ShowUnusedResourcesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitDatabaseName(KernelDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitSetVariable(KernelDistSQLStatementParser.SetVariableContext ctx) {
        return new SetVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()), this.getIdentifierValue((ParseTree)ctx.variableValue()));
    }

    @Override
    public ASTNode visitShowSingleTableRules(KernelDistSQLStatementParser.ShowSingleTableRulesContext ctx) {
        return new ShowSingleTableRulesStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowSingleTable(KernelDistSQLStatementParser.ShowSingleTableContext ctx) {
        return new ShowSingleTableStatement(null == ctx.TABLE() ? null : this.getIdentifierValue((ParseTree)ctx.tableName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitShowVariable(KernelDistSQLStatementParser.ShowVariableContext ctx) {
        return new ShowVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()).toUpperCase());
    }

    @Override
    public ASTNode visitShowAllVariables(KernelDistSQLStatementParser.ShowAllVariablesContext ctx) {
        return new ShowAllVariablesStatement();
    }

    @Override
    public ASTNode visitClearHint(KernelDistSQLStatementParser.ClearHintContext ctx) {
        return new ClearHintStatement();
    }

    @Override
    public ASTNode visitRefreshTableMetadata(KernelDistSQLStatementParser.RefreshTableMetadataContext ctx) {
        if (null == ctx.refreshScope()) {
            return new RefreshTableMetadataStatement();
        }
        String resourceName = null;
        String schemaName = null;
        String tableName = this.getIdentifierValue((ParseTree)ctx.refreshScope().tableName());
        if (null != ctx.refreshScope().fromSegment()) {
            KernelDistSQLStatementParser.FromSegmentContext fromSegment = ctx.refreshScope().fromSegment();
            resourceName = this.getIdentifierValue((ParseTree)fromSegment.resourceName());
            schemaName = null == fromSegment.schemaName() ? null : this.getIdentifierValue((ParseTree)fromSegment.schemaName());
        }
        return new RefreshTableMetadataStatement(tableName, resourceName, schemaName);
    }

    @Override
    public ASTNode visitShowTransactionRule(KernelDistSQLStatementParser.ShowTransactionRuleContext ctx) {
        return new ShowTransactionRuleStatement();
    }

    @Override
    public ASTNode visitAlterTransactionRule(KernelDistSQLStatementParser.AlterTransactionRuleContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.transactionRuleDefinition());
    }

    @Override
    public ASTNode visitTransactionRuleDefinition(KernelDistSQLStatementParser.TransactionRuleDefinitionContext ctx) {
        String defaultType = this.getIdentifierValue((ParseTree)ctx.defaultType());
        if (null != ctx.providerDefinition()) {
            TransactionProviderSegment provider = (TransactionProviderSegment)this.visit((ParseTree)ctx.providerDefinition());
            return new AlterTransactionRuleStatement(defaultType, provider);
        }
        return new AlterTransactionRuleStatement(defaultType, new TransactionProviderSegment(null, null));
    }

    @Override
    public ASTNode visitProviderDefinition(KernelDistSQLStatementParser.ProviderDefinitionContext ctx) {
        return new TransactionProviderSegment(this.getIdentifierValue((ParseTree)ctx.providerName()), this.getProperties(ctx.propertiesDefinition()));
    }

    @Override
    public ASTNode visitShowSQLParserRule(KernelDistSQLStatementParser.ShowSQLParserRuleContext ctx) {
        return new ShowSQLParserRuleStatement();
    }

    @Override
    public ASTNode visitAlterSQLParserRule(KernelDistSQLStatementParser.AlterSQLParserRuleContext ctx) {
        return (ASTNode)super.visit((ParseTree)ctx.sqlParserRuleDefinition());
    }

    @Override
    public ASTNode visitSqlParserRuleDefinition(KernelDistSQLStatementParser.SqlParserRuleDefinitionContext ctx) {
        Boolean sqlCommentParseEnable = null == ctx.sqlCommentParseEnable() ? null : Boolean.valueOf(Boolean.parseBoolean(this.getIdentifierValue((ParseTree)ctx.sqlCommentParseEnable())));
        CacheOptionSegment parseTreeCache = null == ctx.parseTreeCache() ? null : this.visitCacheOption(ctx.parseTreeCache().cacheOption());
        CacheOptionSegment sqlStatementCache = null == ctx.sqlStatementCache() ? null : this.visitCacheOption(ctx.sqlStatementCache().cacheOption());
        return new AlterSQLParserRuleStatement(sqlCommentParseEnable, parseTreeCache, sqlStatementCache);
    }

    @Override
    public CacheOptionSegment visitCacheOption(KernelDistSQLStatementParser.CacheOptionContext ctx) {
        return new CacheOptionSegment(null == ctx.initialCapacity() ? null : Integer.valueOf(Integer.parseInt(this.getIdentifierValue((ParseTree)ctx.initialCapacity()))), null == ctx.maximumSize() ? null : Long.valueOf(Long.parseLong(this.getIdentifierValue((ParseTree)ctx.maximumSize()))));
    }

    @Override
    public ASTNode visitExportDatabaseConfiguration(KernelDistSQLStatementParser.ExportDatabaseConfigurationContext ctx) {
        return new ExportDatabaseConfigurationStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()), this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitConvertYamlConfiguration(KernelDistSQLStatementParser.ConvertYamlConfigurationContext ctx) {
        return new ConvertYamlConfigurationStatement(this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitShowRulesUsedResource(KernelDistSQLStatementParser.ShowRulesUsedResourceContext ctx) {
        return new ShowRulesUsedResourceStatement(this.getIdentifierValue((ParseTree)ctx.resourceName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitPrepareDistSQL(KernelDistSQLStatementParser.PrepareDistSQLContext ctx) {
        return new PrepareDistSQLStatement();
    }

    @Override
    public ASTNode visitApplyDistSQL(KernelDistSQLStatementParser.ApplyDistSQLContext ctx) {
        return new ApplyDistSQLStatement();
    }

    @Override
    public ASTNode visitDiscardDistSQL(KernelDistSQLStatementParser.DiscardDistSQLContext ctx) {
        return new DiscardDistSQLStatement();
    }

    @Override
    public ASTNode visitImportDatabaseConfiguration(KernelDistSQLStatementParser.ImportDatabaseConfigurationContext ctx) {
        return new ImportDatabaseConfigurationStatement(this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitShowSQLTranslatorRule(KernelDistSQLStatementParser.ShowSQLTranslatorRuleContext ctx) {
        return new ShowSQLTranslatorRuleStatement();
    }

    @Override
    public ASTNode visitShowMigrationProcessConfiguration(KernelDistSQLStatementParser.ShowMigrationProcessConfigurationContext ctx) {
        return new ShowMigrationProcessConfigurationStatement();
    }

    @Override
    public ASTNode visitCreateMigrationProcessConfiguration(KernelDistSQLStatementParser.CreateMigrationProcessConfigurationContext ctx) {
        MigrationProcessConfigurationSegment segment = null == ctx.migrationProcessConfiguration() ? null : (MigrationProcessConfigurationSegment)this.visit((ParseTree)ctx.migrationProcessConfiguration());
        return new CreateMigrationProcessConfigurationStatement(segment);
    }

    @Override
    public ASTNode visitAlterMigrationProcessConfiguration(KernelDistSQLStatementParser.AlterMigrationProcessConfigurationContext ctx) {
        MigrationProcessConfigurationSegment segment = null == ctx.migrationProcessConfiguration() ? null : (MigrationProcessConfigurationSegment)this.visit((ParseTree)ctx.migrationProcessConfiguration());
        return new AlterMigrationProcessConfigurationStatement(segment);
    }

    @Override
    public ASTNode visitDropMigrationProcessConfiguration(KernelDistSQLStatementParser.DropMigrationProcessConfigurationContext ctx) {
        return new DropMigrationProcessConfigurationStatement(this.getIdentifierValue((ParseTree)ctx.confPath()));
    }

    @Override
    public ASTNode visitMigrationProcessConfiguration(KernelDistSQLStatementParser.MigrationProcessConfigurationContext ctx) {
        MigrationProcessConfigurationSegment result = new MigrationProcessConfigurationSegment();
        if (null != ctx.readDefinition()) {
            result.setReadSegment((ReadOrWriteSegment)this.visit((ParseTree)ctx.readDefinition()));
        }
        if (null != ctx.writeDefinition()) {
            result.setWriteSegment((ReadOrWriteSegment)this.visit((ParseTree)ctx.writeDefinition()));
        }
        if (null != ctx.streamChannel()) {
            result.setStreamChannel((AlgorithmSegment)this.visit((ParseTree)ctx.streamChannel()));
        }
        return result;
    }

    @Override
    public ASTNode visitReadDefinition(KernelDistSQLStatementParser.ReadDefinitionContext ctx) {
        return new ReadOrWriteSegment(this.getWorkerThread(ctx.workerThread()), this.getBatchSize(ctx.batchSize()), this.getShardingSize(ctx.shardingSize()), this.getAlgorithmSegment(ctx.rateLimiter()));
    }

    @Override
    public ASTNode visitWriteDefinition(KernelDistSQLStatementParser.WriteDefinitionContext ctx) {
        return new ReadOrWriteSegment(this.getWorkerThread(ctx.workerThread()), this.getBatchSize(ctx.batchSize()), this.getAlgorithmSegment(ctx.rateLimiter()));
    }

    private AlgorithmSegment getAlgorithmSegment(KernelDistSQLStatementParser.RateLimiterContext ctx) {
        if (null == ctx) {
            return null;
        }
        return (AlgorithmSegment)this.visit((ParseTree)ctx);
    }

    @Override
    public ASTNode visitAlgorithmDefinition(KernelDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.buildProperties(ctx.propertiesDefinition()));
    }

    private Properties buildProperties(KernelDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx) {
            return result;
        }
        for (KernelDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    private Integer getWorkerThread(KernelDistSQLStatementParser.WorkerThreadContext ctx) {
        if (null == ctx) {
            return null;
        }
        return Integer.parseInt(ctx.intValue().getText());
    }

    private Integer getBatchSize(KernelDistSQLStatementParser.BatchSizeContext ctx) {
        if (null == ctx) {
            return null;
        }
        return Integer.parseInt(ctx.intValue().getText());
    }

    private Integer getShardingSize(KernelDistSQLStatementParser.ShardingSizeContext ctx) {
        if (null == ctx) {
            return null;
        }
        return Integer.parseInt(ctx.intValue().getText());
    }

    @Override
    public ASTNode visitRateLimiter(KernelDistSQLStatementParser.RateLimiterContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitStreamChannel(KernelDistSQLStatementParser.StreamChannelContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }
}

