/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.infra.binder.statement.dal;

import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.RemoveAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTableStatusStatement;

import java.util.Collection;
import java.util.LinkedList;

/**
 * Show table status statement context.
 */
public final class ShowTableStatusStatementContext extends CommonSQLStatementContext implements RemoveAvailable {
    
    public ShowTableStatusStatementContext(final MySQLShowTableStatusStatement sqlStatement) {
        super(sqlStatement);
    }
    
    @Override
    public MySQLShowTableStatusStatement getSqlStatement() {
        return (MySQLShowTableStatusStatement) super.getSqlStatement();
    }
    
    @Override
    public Collection<SQLSegment> getRemoveSegments() {
        Collection<SQLSegment> result = new LinkedList<>();
        getSqlStatement().getFromSchema().ifPresent(result::add);
        return result;
    }
}
