/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type.dialect;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.database.metadata.dialect.OracleDataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;

public final class OracleDatabaseType
implements DatabaseType {
    @Override
    public String getName() {
        return "Oracle";
    }

    @Override
    public QuoteCharacter getQuoteCharacter() {
        return QuoteCharacter.QUOTE;
    }

    @Override
    public Collection<String> getJdbcUrlPrefixes() {
        return Collections.singleton(String.format("jdbc:%s:", this.getName().toLowerCase()));
    }

    @Override
    public OracleDataSourceMetaData getDataSourceMetaData(String url, String username) {
        return new OracleDataSourceMetaData(url, username);
    }

    @Override
    public Optional<String> getDataSourceClassName() {
        return Optional.empty();
    }

    @Override
    public String getSchema(Connection connection) {
        try {
            return Optional.ofNullable(connection.getMetaData().getUserName()).map(String::toUpperCase).orElse(null);
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    @Override
    public String formatTableNamePattern(String tableNamePattern) {
        return tableNamePattern.toUpperCase();
    }

    @Override
    public Map<String, Collection<String>> getSystemDatabaseSchemaMap() {
        return Collections.emptyMap();
    }

    @Override
    public Collection<String> getSystemSchemas() {
        return Collections.emptyList();
    }
}

