/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.loader;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SystemSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.schema.loader.SchemaLoader;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class DatabaseLoader {
    public static ShardingSphereDatabase load(String schemaName, DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules, Properties props) throws SQLException {
        LinkedHashMap<String, ShardingSphereSchema> schemas = new LinkedHashMap<String, ShardingSphereSchema>();
        schemas.put(schemaName, SchemaLoader.load(dataSourceMap, rules, props));
        schemas.putAll(SystemSchemaBuilder.build(schemaName, databaseType));
        return new ShardingSphereDatabase(schemas);
    }

    public static ShardingSphereDatabase load(String databaseName, DatabaseType databaseType) {
        return new ShardingSphereDatabase(SystemSchemaBuilder.build(databaseName, databaseType));
    }
}

