/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.builder;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereConstraint;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.spi.RuleBasedSchemaMetaDataDecorator;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.SchemaMetaDataLoaderEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.SchemaMetaDataLoaderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.ConstraintMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.SchemaMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SchemaMetaDataUtil;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.infra.util.spi.type.ordered.OrderedSPIRegistry;

public final class GenericSchemaBuilder {
    public static Map<String, ShardingSphereSchema> build(GenericSchemaBuilderMaterial material) throws SQLException {
        return GenericSchemaBuilder.build(GenericSchemaBuilder.getAllTableNames(material.getRules()), material);
    }

    public static Map<String, ShardingSphereSchema> build(Collection<String> tableNames, GenericSchemaBuilderMaterial material) throws SQLException {
        Map<String, SchemaMetaData> result = GenericSchemaBuilder.loadSchemas(tableNames, material);
        if (!GenericSchemaBuilder.isProtocolTypeSameWithStorageType(material)) {
            result = GenericSchemaBuilder.translate(result, material);
        }
        return GenericSchemaBuilder.decorate(result, material);
    }

    private static boolean isProtocolTypeSameWithStorageType(GenericSchemaBuilderMaterial material) {
        for (DatabaseType each : material.getStorageTypes().values()) {
            if (material.getProtocolType().equals(each)) continue;
            return false;
        }
        return true;
    }

    private static Collection<String> getAllTableNames(Collection<ShardingSphereRule> rules) {
        return rules.stream().filter(each -> each instanceof TableContainedRule).flatMap(each -> ((TableContainedRule)each).getTables().stream()).collect(Collectors.toSet());
    }

    private static Map<String, SchemaMetaData> loadSchemas(Collection<String> tableNames, GenericSchemaBuilderMaterial material) throws SQLException {
        boolean checkMetaDataEnable = (Boolean)material.getProps().getValue(ConfigurationPropertyKey.CHECK_TABLE_META_DATA_ENABLED);
        Collection<SchemaMetaDataLoaderMaterial> schemaMetaDataLoaderMaterials = SchemaMetaDataUtil.getSchemaMetaDataLoaderMaterials(tableNames, material, checkMetaDataEnable);
        if (schemaMetaDataLoaderMaterials.isEmpty()) {
            return Collections.emptyMap();
        }
        return SchemaMetaDataLoaderEngine.load(schemaMetaDataLoaderMaterials);
    }

    private static Map<String, SchemaMetaData> translate(Map<String, SchemaMetaData> schemaMetaDataMap, GenericSchemaBuilderMaterial material) {
        LinkedList<TableMetaData> tableMetaDataList = new LinkedList<TableMetaData>();
        for (DatabaseType each : material.getStorageTypes().values()) {
            String defaultSchemaName = DatabaseTypeEngine.getDefaultSchemaName(each, material.getDefaultSchemaName());
            tableMetaDataList.addAll(Optional.ofNullable(schemaMetaDataMap.get(defaultSchemaName)).map(SchemaMetaData::getTables).orElseGet(Collections::emptyList));
        }
        String frontendSchemaName = DatabaseTypeEngine.getDefaultSchemaName(material.getProtocolType(), material.getDefaultSchemaName());
        LinkedHashMap<String, SchemaMetaData> result = new LinkedHashMap<String, SchemaMetaData>();
        result.put(frontendSchemaName, new SchemaMetaData(frontendSchemaName, tableMetaDataList));
        return result;
    }

    private static Map<String, ShardingSphereSchema> decorate(Map<String, SchemaMetaData> schemaMetaDataMap, GenericSchemaBuilderMaterial material) {
        LinkedHashMap<String, SchemaMetaData> result = new LinkedHashMap<String, SchemaMetaData>(schemaMetaDataMap);
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServices(RuleBasedSchemaMetaDataDecorator.class, material.getRules()).entrySet()) {
            if (!(entry.getKey() instanceof TableContainedRule)) continue;
            result.putAll(((RuleBasedSchemaMetaDataDecorator)entry.getValue()).decorate(result, (TableContainedRule)entry.getKey(), material));
        }
        return GenericSchemaBuilder.convertToSchemaMap(result, material);
    }

    private static Map<String, ShardingSphereSchema> convertToSchemaMap(Map<String, SchemaMetaData> schemaMetaDataMap, GenericSchemaBuilderMaterial material) {
        if (schemaMetaDataMap.isEmpty()) {
            return Collections.singletonMap(material.getDefaultSchemaName(), new ShardingSphereSchema());
        }
        ConcurrentHashMap<String, ShardingSphereSchema> result = new ConcurrentHashMap<String, ShardingSphereSchema>(schemaMetaDataMap.size(), 1.0f);
        for (Map.Entry<String, SchemaMetaData> entry : schemaMetaDataMap.entrySet()) {
            Map<String, ShardingSphereTable> tables = GenericSchemaBuilder.convertToTableMap(entry.getValue().getTables());
            result.put(entry.getKey().toLowerCase(), new ShardingSphereSchema(tables, new LinkedHashMap<String, ShardingSphereView>()));
        }
        return result;
    }

    private static Map<String, ShardingSphereTable> convertToTableMap(Collection<TableMetaData> tableMetaDataList) {
        LinkedHashMap<String, ShardingSphereTable> result = new LinkedHashMap<String, ShardingSphereTable>(tableMetaDataList.size(), 1.0f);
        for (TableMetaData each : tableMetaDataList) {
            Collection<ShardingSphereColumn> columns = GenericSchemaBuilder.convertToColumns(each.getColumns());
            Collection<ShardingSphereIndex> indexes = GenericSchemaBuilder.convertToIndexes(each.getIndexes());
            Collection<ShardingSphereConstraint> constraints = GenericSchemaBuilder.convertToConstraints(each.getConstrains());
            result.put(each.getName(), new ShardingSphereTable(each.getName(), columns, indexes, constraints));
        }
        return result;
    }

    private static Collection<ShardingSphereColumn> convertToColumns(Collection<ColumnMetaData> columnMetaDataList) {
        LinkedList<ShardingSphereColumn> result = new LinkedList<ShardingSphereColumn>();
        for (ColumnMetaData each : columnMetaDataList) {
            result.add(new ShardingSphereColumn(each.getName(), each.getDataType(), each.isPrimaryKey(), each.isGenerated(), each.isCaseSensitive(), each.isVisible(), each.isUnsigned()));
        }
        return result;
    }

    private static Collection<ShardingSphereIndex> convertToIndexes(Collection<IndexMetaData> indexMetaDataList) {
        LinkedList<ShardingSphereIndex> result = new LinkedList<ShardingSphereIndex>();
        for (IndexMetaData each : indexMetaDataList) {
            result.add(new ShardingSphereIndex(each.getName()));
        }
        return result;
    }

    private static Collection<ShardingSphereConstraint> convertToConstraints(Collection<ConstraintMetaData> constraintMetaDataList) {
        LinkedList<ShardingSphereConstraint> result = new LinkedList<ShardingSphereConstraint>();
        for (ConstraintMetaData each : constraintMetaDataList) {
            result.add(new ShardingSphereConstraint(each.getName(), each.getReferencedTableName()));
        }
        return result;
    }
}

