/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.rule;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class ShardingSphereRuleMetaData {
    private final Collection<ShardingSphereRule> rules;

    public ShardingSphereRuleMetaData(Collection<ShardingSphereRule> rules) {
        this.rules = new CopyOnWriteArrayList<ShardingSphereRule>(rules);
    }

    public Collection<RuleConfiguration> getConfigurations() {
        return this.rules.stream().map(ShardingSphereRule::getConfiguration).collect(Collectors.toList());
    }

    public <T extends ShardingSphereRule> Collection<T> findRules(Class<T> clazz) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        for (ShardingSphereRule each : this.rules) {
            if (!clazz.isAssignableFrom(each.getClass())) continue;
            result.add((ShardingSphereRule)clazz.cast(each));
        }
        return result;
    }

    public <T extends ShardingSphereRule> Optional<T> findSingleRule(Class<T> clazz) {
        Collection<T> foundRules = this.findRules(clazz);
        return foundRules.isEmpty() ? Optional.empty() : Optional.of((ShardingSphereRule)foundRules.iterator().next());
    }

    public <T extends ShardingSphereRule> T getSingleRule(Class<T> clazz) {
        Collection<T> foundRules = this.findRules(clazz);
        Preconditions.checkState((1 == foundRules.size() ? 1 : 0) != 0, (String)"Rule `%s` should have and only have one instance.", (Object)clazz.getSimpleName());
        return (T)((ShardingSphereRule)foundRules.iterator().next());
    }

    @Generated
    public Collection<ShardingSphereRule> getRules() {
        return this.rules;
    }
}

