/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.datasource.pool.CatalogSwitchableDataSource;
import org.apache.shardingsphere.infra.datasource.pool.hikari.metadata.HikariDataSourcePoolFieldMetaData;
import org.apache.shardingsphere.infra.datasource.pool.hikari.metadata.HikariDataSourcePoolMetaData;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.reflection.ReflectionUtils;

public final class DatabaseTypeEngine {
    private static final String DEFAULT_DATABASE_TYPE = "MySQL";

    public static DatabaseType getProtocolType(DatabaseConfiguration databaseConfig, ConfigurationProperties props) {
        Optional<DatabaseType> configuredDatabaseType = DatabaseTypeEngine.findConfiguredDatabaseType(props);
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        Collection<DataSource> dataSources = DatabaseTypeEngine.getDataSources(databaseConfig).values();
        return dataSources.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : DatabaseTypeEngine.getStorageType(dataSources.iterator().next());
    }

    public static DatabaseType getProtocolType(Map<String, ? extends DatabaseConfiguration> databaseConfigs, ConfigurationProperties props) {
        Optional<DatabaseType> configuredDatabaseType = DatabaseTypeEngine.findConfiguredDatabaseType(props);
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        Map<String, DataSource> dataSources = DatabaseTypeEngine.getDataSources(databaseConfigs);
        return dataSources.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : DatabaseTypeEngine.getStorageType(dataSources.values().iterator().next());
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType(ConfigurationProperties props) {
        DatabaseType configuredDatabaseType = (DatabaseType)props.getValue(ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return null == configuredDatabaseType ? Optional.empty() : Optional.of(configuredDatabaseType.getTrunkDatabaseType().orElse(configuredDatabaseType));
    }

    private static Map<String, DataSource> getDataSources(Map<String, ? extends DatabaseConfiguration> databaseConfigs) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry<String, ? extends DatabaseConfiguration> entry : databaseConfigs.entrySet()) {
            result.putAll(DatabaseTypeEngine.getDataSources(entry.getValue()));
        }
        return result;
    }

    private static Map<String, DataSource> getDataSources(DatabaseConfiguration databaseConfig) {
        return databaseConfig.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public static Map<String, DatabaseType> getStorageTypes(DatabaseConfiguration databaseConfig) {
        LinkedHashMap<String, DatabaseType> result = new LinkedHashMap<String, DatabaseType>(databaseConfig.getStorageUnits().size(), 1.0f);
        Map<String, DataSource> dataSources = DatabaseTypeEngine.getDataSources(databaseConfig);
        for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
            result.put(entry.getKey(), DatabaseTypeEngine.getStorageType(entry.getValue()));
        }
        return result;
    }

    public static DatabaseType getStorageType(DataSource dataSource) {
        DatabaseType databaseType;
        block11: {
            Connection connection = dataSource.getConnection();
            try {
                databaseType = DatabaseTypeFactory.get((String)connection.getMetaData().getURL());
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLFeatureNotSupportedException sqlFeatureNotSupportedException) {
                    if (dataSource instanceof CatalogSwitchableDataSource) {
                        return DatabaseTypeFactory.get((String)((CatalogSwitchableDataSource)dataSource).getUrl());
                    }
                    if (dataSource.getClass().getName().equals(new HikariDataSourcePoolMetaData().getType())) {
                        HikariDataSourcePoolFieldMetaData dataSourcePoolFieldMetaData = new HikariDataSourcePoolFieldMetaData();
                        String jdbcUrlFieldName = (String)ReflectionUtils.getFieldValue((Object)dataSource, (String)dataSourcePoolFieldMetaData.getJdbcUrlFieldName()).orElseThrow(() -> new SQLWrapperException((SQLException)sqlFeatureNotSupportedException));
                        return DatabaseTypeFactory.get((String)jdbcUrlFieldName);
                    }
                    throw new SQLWrapperException((SQLException)sqlFeatureNotSupportedException);
                }
                catch (SQLException ex) {
                    throw new SQLWrapperException(ex);
                }
            }
            connection.close();
        }
        return databaseType;
    }

    public static DatabaseType getDefaultStorageType() {
        return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)DEFAULT_DATABASE_TYPE);
    }

    @Generated
    private DatabaseTypeEngine() {
    }
}

