/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutorDataMap;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessStrategyEvaluator;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessConstants;
import org.apache.shardingsphere.infra.executor.sql.process.spi.ExecuteProcessReporter;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class ExecuteProcessEngine {
    private static final Collection<ExecuteProcessReporter> HANDLERS;

    public static void initialize(LogicSQL logicSQL, ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, ConfigurationProperties props) {
        SQLStatementContext context = logicSQL.getSqlStatementContext();
        if (!HANDLERS.isEmpty() && ExecuteProcessStrategyEvaluator.evaluate(context, executionGroupContext, props)) {
            ExecutorDataMap.getValue().put(ExecuteProcessConstants.EXECUTE_ID.name(), executionGroupContext.getExecutionID());
            HANDLERS.iterator().next().report(logicSQL, executionGroupContext, ExecuteProcessConstants.EXECUTE_STATUS_START);
        }
    }

    public static void clean() {
        ExecutorDataMap.getValue().remove(ExecuteProcessConstants.EXECUTE_ID.name());
    }

    public static void finish(String executionID, SQLExecutionUnit executionUnit) {
        if (!HANDLERS.isEmpty()) {
            HANDLERS.iterator().next().report(executionID, executionUnit, ExecuteProcessConstants.EXECUTE_STATUS_DONE);
        }
    }

    public static void finish(String executionID) {
        if (!HANDLERS.isEmpty() && ExecutorDataMap.getValue().containsKey(ExecuteProcessConstants.EXECUTE_ID.name())) {
            HANDLERS.iterator().next().report(executionID, ExecuteProcessConstants.EXECUTE_STATUS_DONE);
        }
    }

    @Generated
    private ExecuteProcessEngine() {
    }

    static {
        ShardingSphereServiceLoader.register(ExecuteProcessReporter.class);
        HANDLERS = ShardingSphereServiceLoader.newServiceInstances(ExecuteProcessReporter.class);
    }
}

