/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.Process;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessRegistry;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class ProcessEngine {
    public String connect(String databaseName) {
        return this.connect(new ExecutionGroupReportContext(this.getProcessId(), databaseName));
    }

    public String connect(String databaseName, Grantee grantee) {
        return this.connect(new ExecutionGroupReportContext(this.getProcessId(), databaseName, grantee));
    }

    private String connect(ExecutionGroupReportContext reportContext) {
        ExecutionGroupContext executionGroupContext = new ExecutionGroupContext(Collections.emptyList(), reportContext);
        ProcessRegistry.getInstance().add(new Process(executionGroupContext));
        return executionGroupContext.getReportContext().getProcessId();
    }

    private String getProcessId() {
        return new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString().replace("-", "");
    }

    public void disconnect(String processId) {
        ProcessRegistry.getInstance().remove(processId);
    }

    public void executeSQL(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, QueryContext queryContext) {
        ProcessRegistry.getInstance().add(new Process(queryContext.getSql(), executionGroupContext));
    }

    public void completeSQLUnitExecution(SQLExecutionUnit executionUnit, String processId) {
        if (Strings.isNullOrEmpty((String)processId)) {
            return;
        }
        Process process = ProcessRegistry.getInstance().get(processId);
        if (null == process) {
            return;
        }
        process.completeExecutionUnit();
        process.removeProcessStatement(executionUnit.getExecutionUnit());
    }

    public void completeSQLExecution(String processId) {
        if (Strings.isNullOrEmpty((String)processId)) {
            return;
        }
        Process process = ProcessRegistry.getInstance().get(processId);
        if (null == process) {
            return;
        }
        ExecutionGroupContext executionGroupContext = new ExecutionGroupContext(Collections.emptyList(), new ExecutionGroupReportContext(processId, process.getDatabaseName(), new Grantee(process.getUsername(), process.getHostname())));
        ProcessRegistry.getInstance().add(new Process(executionGroupContext));
    }
}

