/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.shardingsphere.infra.executor.sql.process.lock.ProcessOperationLockReleaseStrategy;

public final class ProcessOperationLock {
    private static final long TIMEOUT_MILLS = 5000L;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean awaitDefaultTime(ProcessOperationLockReleaseStrategy releaseStrategy) {
        while (!releaseStrategy.isReadyToRelease()) {
            if (!this.condition.await(5000L, TimeUnit.MILLISECONDS)) continue;
            return false;
        }
        return true;
    }

    public void doNotify() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

