/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.generator.generic;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.RemoveToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.RemoveAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowColumnsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTableStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTablesStatement;

public final class RemoveTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext<?>> {
    @Override
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext.getSqlStatement() instanceof MySQLShowTablesStatement) {
            return ((MySQLShowTablesStatement)sqlStatementContext.getSqlStatement()).getFromSchema().isPresent();
        }
        if (sqlStatementContext.getSqlStatement() instanceof MySQLShowTableStatusStatement) {
            return ((MySQLShowTableStatusStatement)sqlStatementContext.getSqlStatement()).getFromSchema().isPresent();
        }
        if (sqlStatementContext.getSqlStatement() instanceof MySQLShowColumnsStatement) {
            return ((MySQLShowColumnsStatement)sqlStatementContext.getSqlStatement()).getFromSchema().isPresent();
        }
        if (sqlStatementContext.getSqlStatement() instanceof SelectStatement) {
            return ((SelectStatement)sqlStatementContext.getSqlStatement()).getHaving().isPresent();
        }
        return false;
    }

    @Override
    public Collection<RemoveToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext.getSqlStatement() instanceof MySQLShowTablesStatement) {
            Preconditions.checkState((boolean)((MySQLShowTablesStatement)sqlStatementContext.getSqlStatement()).getFromSchema().isPresent());
            RemoveAvailable removeAvailable = (RemoveAvailable)((MySQLShowTablesStatement)sqlStatementContext.getSqlStatement()).getFromSchema().get();
            return Collections.singletonList(new RemoveToken(removeAvailable.getStartIndex(), removeAvailable.getStopIndex()));
        }
        if (sqlStatementContext.getSqlStatement() instanceof MySQLShowTableStatusStatement) {
            Preconditions.checkState((boolean)((MySQLShowTableStatusStatement)sqlStatementContext.getSqlStatement()).getFromSchema().isPresent());
            RemoveAvailable removeAvailable = (RemoveAvailable)((MySQLShowTableStatusStatement)sqlStatementContext.getSqlStatement()).getFromSchema().get();
            return Collections.singletonList(new RemoveToken(removeAvailable.getStartIndex(), removeAvailable.getStopIndex()));
        }
        if (sqlStatementContext.getSqlStatement() instanceof MySQLShowColumnsStatement) {
            Preconditions.checkState((boolean)((MySQLShowColumnsStatement)sqlStatementContext.getSqlStatement()).getFromSchema().isPresent());
            RemoveAvailable removeAvailable = (RemoveAvailable)((MySQLShowColumnsStatement)sqlStatementContext.getSqlStatement()).getFromSchema().get();
            return Collections.singletonList(new RemoveToken(removeAvailable.getStartIndex(), removeAvailable.getStopIndex()));
        }
        if (sqlStatementContext.getSqlStatement() instanceof SelectStatement) {
            Preconditions.checkState((boolean)((SelectStatement)sqlStatementContext.getSqlStatement()).getHaving().isPresent());
            RemoveAvailable removeAvailable = (RemoveAvailable)((SelectStatement)sqlStatementContext.getSqlStatement()).getHaving().get();
            return Collections.singletonList(new RemoveToken(removeAvailable.getStartIndex(), removeAvailable.getStopIndex()));
        }
        return Collections.emptyList();
    }
}

