/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine.impl;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.engine.SQLRouteExecutor;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;

public final class PartialSQLRouteExecutor
implements SQLRouteExecutor {
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLRouter> routers;

    public PartialSQLRouteExecutor(Collection<ShardingSphereRule> rules, ConfigurationProperties props) {
        this.props = props;
        this.routers = OrderedSPIRegistry.getRegisteredServices(rules, SQLRouter.class);
    }

    @Override
    public RouteContext route(LogicSQL logicSQL, ShardingSphereSchema schema) {
        RouteContext result = new RouteContext();
        for (Map.Entry<ShardingSphereRule, SQLRouter> entry : this.routers.entrySet()) {
            if (result.getRouteUnits().isEmpty()) {
                result = entry.getValue().createRouteContext(logicSQL, schema, entry.getKey(), this.props);
                continue;
            }
            entry.getValue().decorateRouteContext(result, logicSQL, schema, entry.getKey(), this.props);
        }
        return result;
    }

    static {
        ShardingSphereServiceLoader.register(SQLRouter.class);
    }
}

