/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import lombok.Generated;

public final class ReflectionUtil {
    public static <T> Optional<T> getFieldValue(Object target, String fieldName) {
        return ReflectionUtil.findField(fieldName, target.getClass()).map(optional -> ReflectionUtil.getFieldValue(target, optional));
    }

    private static <T> T getFieldValue(Object target, Field field) {
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        Object result = field.get(target);
        if (!accessible) {
            field.setAccessible(false);
        }
        return (T)result;
    }

    private static Optional<Field> findField(String fieldName, Class<?> targetClass) {
        for (Class<?> currentTargetClass = targetClass; Object.class != currentTargetClass; currentTargetClass = currentTargetClass.getSuperclass()) {
            try {
                return Optional.of(currentTargetClass.getDeclaredField(fieldName));
            }
            catch (NoSuchFieldException ignored) {
                continue;
            }
        }
        return Optional.empty();
    }

    public static <T> T getStaticFieldValue(Class<?> target, String fieldName) {
        Field field = target.getDeclaredField(fieldName);
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        Object result = field.get(target);
        if (!accessible) {
            field.setAccessible(false);
        }
        return (T)result;
    }

    public static void setStaticFieldValue(Class<?> target, String fieldName, Object value) {
        Field field = target.getDeclaredField(fieldName);
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        field.set(target, value);
        if (!accessible) {
            field.setAccessible(false);
        }
    }

    public static <T> T invokeMethod(Method method, Object target, Object ... args) {
        boolean accessible = method.isAccessible();
        if (!accessible) {
            method.setAccessible(true);
        }
        Object result = method.invoke(target, args);
        if (!accessible) {
            method.setAccessible(false);
        }
        return (T)result;
    }

    @Generated
    private ReflectionUtil() {
    }
}

