/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.handler.converter.ShadowRuleStatementConverter;
import org.apache.shardingsphere.shadow.distsql.handler.supporter.ShadowRuleStatementSupporter;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowRuleSegment;
import org.apache.shardingsphere.shadow.distsql.parser.statement.CreateShadowRuleStatement;

public final class CreateShadowRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateShadowRuleStatement, ShadowRuleConfiguration> {
    private static final String SHADOW = "shadow";

    public RuleConfiguration buildToBeCreatedRuleConfiguration(CreateShadowRuleStatement sqlStatement) {
        return ShadowRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public void updateCurrentRuleConfiguration(ShadowRuleConfiguration currentRuleConfig, ShadowRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDataSources().putAll(toBeCreatedRuleConfig.getDataSources());
            currentRuleConfig.getShadowAlgorithms().putAll(toBeCreatedRuleConfig.getShadowAlgorithms());
            this.updateTables(currentRuleConfig.getTables(), toBeCreatedRuleConfig.getTables());
        }
    }

    private void updateTables(Map<String, ShadowTableConfiguration> currentTables, Map<String, ShadowTableConfiguration> toBeCreateTables) {
        toBeCreateTables.forEach((key, value) -> currentTables.merge((String)key, (ShadowTableConfiguration)value, ShadowRuleStatementSupporter::mergeConfiguration));
    }

    public void checkSQLStatement(ShardingSphereMetaData metaData, CreateShadowRuleStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = metaData.getName();
        Collection rules = sqlStatement.getRules();
        this.checkRuleNames(schemaName, rules, currentRuleConfig);
        this.checkResources(schemaName, rules, metaData);
        this.checkAlgorithms(schemaName, rules, currentRuleConfig);
    }

    private void checkRuleNames(String schemaName, Collection<ShadowRuleSegment> rules, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        List<String> requireRuleNames = ShadowRuleStatementSupporter.getRuleNames(rules);
        ShadowRuleStatementChecker.checkAnyDuplicate(requireRuleNames, duplicate -> new DuplicateRuleException(SHADOW, schemaName, duplicate));
        List<String> currentRuleName = ShadowRuleStatementSupporter.getRuleNames(currentRuleConfig);
        ShadowRuleStatementChecker.checkAnyDuplicate(requireRuleNames, currentRuleName, identical -> new DuplicateRuleException(SHADOW, schemaName, identical));
    }

    private void checkResources(String schemaName, Collection<ShadowRuleSegment> rules, ShardingSphereMetaData metaData) throws DistSQLException {
        List<String> requireResource = ShadowRuleStatementSupporter.getResourceNames(rules);
        ShadowRuleStatementChecker.checkResourceExist(requireResource, metaData, schemaName);
    }

    private void checkAlgorithms(String schemaName, Collection<ShadowRuleSegment> rules, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        List<ShadowAlgorithmSegment> requireAlgorithms = ShadowRuleStatementSupporter.getShadowAlgorithmSegment(rules);
        ShadowRuleStatementChecker.checkAlgorithmCompleteness(requireAlgorithms);
        List<String> requireAlgorithmNames = ShadowRuleStatementSupporter.getAlgorithmNames(rules);
        ShadowRuleStatementChecker.checkAnyDuplicate(requireAlgorithmNames, duplicate -> new DuplicateRuleException(SHADOW, schemaName, duplicate));
        List<String> currentAlgorithmNames = ShadowRuleStatementSupporter.getAlgorithmNames(currentRuleConfig);
        ShadowRuleStatementChecker.checkAnyDuplicate(requireAlgorithmNames, currentAlgorithmNames, duplicate -> new DuplicateRuleException(SHADOW, schemaName, duplicate));
    }

    public Class<ShadowRuleConfiguration> getRuleConfigurationClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getType() {
        return CreateShadowRuleStatement.class.getName();
    }
}

