/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.PipelineJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPI;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.scaling.distsql.statement.CheckScalingStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class CheckScalingQueryResultSet
implements DistSQLResultSet {
    private static final RuleAlteredJobAPI RULE_ALTERED_JOB_API = PipelineJobAPIFactory.getRuleAlteredJobAPI();
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        CheckScalingStatement checkScalingStatement = (CheckScalingStatement)sqlStatement;
        Map checkResultMap = null == checkScalingStatement.getTypeStrategy() ? RULE_ALTERED_JOB_API.dataConsistencyCheck(checkScalingStatement.getJobId()) : RULE_ALTERED_JOB_API.dataConsistencyCheck(checkScalingStatement.getJobId(), checkScalingStatement.getTypeStrategy().getName());
        this.data = checkResultMap.entrySet().stream().map(each -> {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(each.getKey());
            list.add(((DataConsistencyCheckResult)each.getValue()).getSourceRecordsCount());
            list.add(((DataConsistencyCheckResult)each.getValue()).getTargetRecordsCount());
            list.add(((DataConsistencyCheckResult)each.getValue()).isRecordsCountMatched() + "");
            list.add(((DataConsistencyCheckResult)each.getValue()).isRecordsContentMatched() + "");
            return list;
        }).collect(Collectors.toList()).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("table_name", "source_records_count", "target_records_count", "records_count_matched", "records_content_matched");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return CheckScalingStatement.class.getName();
    }
}

