/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.PipelineJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPI;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShowScalingJobStatusQueryResultSet
implements DistSQLResultSet {
    private static final RuleAlteredJobAPI RULE_ALTERED_JOB_API = PipelineJobAPIFactory.getRuleAlteredJobAPI();
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        long currentTimeMillis = System.currentTimeMillis();
        this.data = RULE_ALTERED_JOB_API.getProgress(((ShowScalingStatusStatement)sqlStatement).getJobId()).entrySet().stream().map(entry -> {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(entry.getKey());
            if (null != entry.getValue()) {
                list.add(((JobProgress)entry.getValue()).getDataSource());
                list.add(((JobProgress)entry.getValue()).getStatus());
                list.add(((JobProgress)entry.getValue()).isActive() ? "true" : "false");
                list.add(((JobProgress)entry.getValue()).getInventoryFinishedPercentage());
                long latestActiveTimeMillis = ((JobProgress)entry.getValue()).getIncrementalLatestActiveTimeMillis();
                list.add(latestActiveTimeMillis > 0L ? TimeUnit.MILLISECONDS.toMinutes(currentTimeMillis - latestActiveTimeMillis) : 0L);
            } else {
                list.add("");
                list.add("");
                list.add("");
                list.add("");
                list.add("");
            }
            return list;
        }).collect(Collectors.toList()).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("item", "data_source", "status", "active", "inventory_finished_percentage", "incremental_idle_minutes");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowScalingStatusStatement.class.getName();
    }
}

