/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.alibaba.dubbo;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.config.spring.ServiceBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.dubbo.common.annotation.ShenyuDubboClient;
import org.apache.shenyu.client.dubbo.common.dto.DubboRpcExt;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.ReflectionUtils;

public class AlibabaDubboServiceBeanListener
implements ApplicationListener<ContextRefreshedEvent> {
    private ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private AtomicBoolean registered = new AtomicBoolean(false);
    private final String contextPath;
    private final String appName;
    private final String host;
    private final String port;

    public AlibabaDubboServiceBeanListener(ShenyuRegisterCenterConfig config, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        Properties props = config.getProps();
        String contextPath = props.getProperty("contextPath");
        String appName = props.getProperty("appName");
        if (StringUtils.isEmpty((String)contextPath)) {
            throw new RuntimeException("apache dubbo client must config the contextPath");
        }
        this.contextPath = contextPath;
        this.appName = appName;
        this.host = props.getProperty("host");
        this.port = props.getProperty("port");
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        Map serviceBean = contextRefreshedEvent.getApplicationContext().getBeansOfType(ServiceBean.class);
        for (Map.Entry entry : serviceBean.entrySet()) {
            this.handler((ServiceBean)entry.getValue());
        }
        serviceBean.values().stream().findFirst().ifPresent(bean -> this.publisher.publishEvent((Object)this.buildURIRegisterDTO((ServiceBean)bean)));
    }

    private void handler(ServiceBean<?> serviceBean) {
        Method[] methods;
        Object refProxy = serviceBean.getRef();
        Class clazz = refProxy.getClass();
        if (AopUtils.isAopProxy((Object)refProxy)) {
            clazz = AopUtils.getTargetClass((Object)refProxy);
        }
        for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods(clazz)) {
            ShenyuDubboClient shenyuDubboClient = method.getAnnotation(ShenyuDubboClient.class);
            if (!Objects.nonNull(shenyuDubboClient)) continue;
            this.publisher.publishEvent((Object)this.buildMetaDataDTO(serviceBean, shenyuDubboClient, method));
        }
    }

    private MetaDataRegisterDTO buildMetaDataDTO(ServiceBean<?> serviceBean, ShenyuDubboClient shenyuDubboClient, Method method) {
        String appName = this.buildAppName(serviceBean);
        String path = this.contextPath + shenyuDubboClient.path();
        String desc = shenyuDubboClient.desc();
        String serviceName = serviceBean.getInterface();
        String configRuleName = shenyuDubboClient.ruleName();
        String ruleName = "".equals(configRuleName) ? path : configRuleName;
        String methodName = method.getName();
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        return MetaDataRegisterDTO.builder().appName(appName).serviceName(serviceName).methodName(methodName).contextPath(this.contextPath).host(this.buildHost()).port(Integer.valueOf(this.buildPort(serviceBean))).path(path).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcExt(this.buildRpcExt(serviceBean)).rpcType(RpcTypeEnum.DUBBO.getName()).enabled(shenyuDubboClient.enabled()).build();
    }

    private URIRegisterDTO buildURIRegisterDTO(ServiceBean serviceBean) {
        return URIRegisterDTO.builder().contextPath(this.contextPath).appName(this.buildAppName(serviceBean)).rpcType(RpcTypeEnum.DUBBO.getName()).host(this.buildHost()).port(Integer.valueOf(this.buildPort(serviceBean))).build();
    }

    private String buildRpcExt(ServiceBean<?> serviceBean) {
        DubboRpcExt builder = DubboRpcExt.builder().group(StringUtils.isNotEmpty((String)serviceBean.getGroup()) ? serviceBean.getGroup() : "").version(StringUtils.isNotEmpty((String)serviceBean.getVersion()) ? serviceBean.getVersion() : "").loadbalance(StringUtils.isNotEmpty((String)serviceBean.getLoadbalance()) ? serviceBean.getLoadbalance() : "random").retries(Integer.valueOf(Objects.isNull(serviceBean.getRetries()) ? 2 : serviceBean.getRetries())).timeout(Integer.valueOf(Objects.isNull(serviceBean.getTimeout()) ? 3000 : serviceBean.getTimeout())).url("").build();
        return GsonUtils.getInstance().toJson((Object)builder);
    }

    private String buildAppName(ServiceBean serviceBean) {
        return StringUtils.isBlank((String)this.appName) ? serviceBean.getApplication().getName() : this.appName;
    }

    private String buildHost() {
        return IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
    }

    private int buildPort(ServiceBean serviceBean) {
        return StringUtils.isBlank((String)this.port) ? serviceBean.getProtocol().getPort() : Integer.parseInt(this.port);
    }
}

