/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.alibaba.dubbo.validation;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.bytecode.ClassGenerator;
import com.alibaba.dubbo.common.utils.ReflectUtils;
import com.alibaba.dubbo.validation.MethodValidated;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.validation.Constraint;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlibabaDubboClientValidator
implements com.alibaba.dubbo.validation.Validator {
    private static final Logger LOG = LoggerFactory.getLogger(AlibabaDubboClientValidator.class);
    private final Class<?> clazz;
    private final Validator validator;

    public AlibabaDubboClientValidator(URL url) {
        this.clazz = ReflectUtils.forName((String)url.getServiceInterface());
        String shenyuValidation = url.getParameter("shenyuValidation");
        ValidatorFactory factory = shenyuValidation != null && shenyuValidation.length() > 0 ? Validation.byProvider((Class)ReflectUtils.forName((String)shenyuValidation)).configure().buildValidatorFactory() : Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
    }

    private static boolean isPrimitives(Class<?> cls) {
        if (cls.isArray()) {
            return AlibabaDubboClientValidator.isPrimitive(cls.getComponentType());
        }
        return AlibabaDubboClientValidator.isPrimitive(cls);
    }

    private static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == String.class || cls == Boolean.class || cls == Character.class || Number.class.isAssignableFrom(cls) || Date.class.isAssignableFrom(cls);
    }

    private static Object getMethodParameterBean(Class<?> clazz, Method method, Object[] args) {
        if (!AlibabaDubboClientValidator.hasConstraintParameter(method)) {
            return null;
        }
        try {
            Class parameterClass;
            String parameterClassName = AlibabaDubboClientValidator.generateMethodParameterClassName(clazz, method);
            try {
                parameterClass = Class.forName(parameterClassName, true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                ClassPool pool = ClassGenerator.getClassPool((ClassLoader)clazz.getClassLoader());
                CtClass ctClass = pool.makeClass(parameterClassName);
                ClassFile classFile = ctClass.getClassFile();
                classFile.setVersionToJava5();
                ctClass.addConstructor(CtNewConstructor.defaultConstructor((CtClass)pool.getCtClass(parameterClassName)));
                Class<?>[] parameterTypes = method.getParameterTypes();
                java.lang.annotation.Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> type = parameterTypes[i];
                    java.lang.annotation.Annotation[] annotations = parameterAnnotations[i];
                    AnnotationsAttribute attribute = new AnnotationsAttribute(classFile.getConstPool(), "RuntimeVisibleAnnotations");
                    for (java.lang.annotation.Annotation annotation : annotations) {
                        Method[] members;
                        if (!annotation.annotationType().isAnnotationPresent(Constraint.class)) continue;
                        Annotation ja = new Annotation(classFile.getConstPool(), pool.getCtClass(annotation.annotationType().getName()));
                        for (Method member : members = annotation.annotationType().getMethods()) {
                            Object value;
                            if (!Modifier.isPublic((int)member.getModifiers()) || member.getParameterTypes().length != 0 || member.getDeclaringClass() != annotation.annotationType() || null == (value = member.invoke((Object)annotation, new Object[0]))) continue;
                            MemberValue memberValue = AlibabaDubboClientValidator.createMemberValue(classFile.getConstPool(), pool.get(member.getReturnType().getName()), value);
                            ja.addMemberValue(member.getName(), memberValue);
                        }
                        attribute.addAnnotation(ja);
                    }
                    String fieldName = method.getName() + "Argument" + i;
                    CtField ctField = CtField.make((String)("public " + type.getCanonicalName() + " " + fieldName + ";"), (CtClass)pool.getCtClass(parameterClassName));
                    ctField.getFieldInfo().addAttribute((AttributeInfo)attribute);
                    ctClass.addField(ctField);
                }
                parameterClass = ctClass.toClass(clazz.getClassLoader(), null);
            }
            Object parameterBean = parameterClass.newInstance();
            for (int i = 0; i < args.length; ++i) {
                Field field = parameterClass.getField(method.getName() + "Argument" + i);
                field.set(parameterBean, args[i]);
            }
            return parameterBean;
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String generateMethodParameterClassName(Class<?> clazz, Method method) {
        Class<?>[] parameterTypes;
        StringBuilder builder = new StringBuilder().append(clazz.getName()).append("_").append(AlibabaDubboClientValidator.toUpperMethodName(method.getName())).append("Parameter");
        for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
            builder.append("_").append(parameterType.getName());
        }
        return builder.toString();
    }

    private static boolean hasConstraintParameter(Method method) {
        java.lang.annotation.Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length > 0) {
            java.lang.annotation.Annotation[][] annotationArray = parameterAnnotations;
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                java.lang.annotation.Annotation[] annotations;
                for (java.lang.annotation.Annotation annotation : annotations = annotationArray[i]) {
                    if (!annotation.annotationType().isAnnotationPresent(Constraint.class)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String toUpperMethodName(String methodName) {
        return methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    private static MemberValue createMemberValue(ConstPool cp, CtClass type, Object value) throws NotFoundException {
        MemberValue memberValue = Annotation.createMemberValue((ConstPool)cp, (CtClass)type);
        if (memberValue instanceof BooleanMemberValue) {
            ((BooleanMemberValue)memberValue).setValue(((Boolean)value).booleanValue());
        } else if (memberValue instanceof ByteMemberValue) {
            ((ByteMemberValue)memberValue).setValue(((Byte)value).byteValue());
        } else if (memberValue instanceof CharMemberValue) {
            ((CharMemberValue)memberValue).setValue(((Character)value).charValue());
        } else if (memberValue instanceof ShortMemberValue) {
            ((ShortMemberValue)memberValue).setValue(((Short)value).shortValue());
        } else if (memberValue instanceof IntegerMemberValue) {
            ((IntegerMemberValue)memberValue).setValue(((Integer)value).intValue());
        } else if (memberValue instanceof LongMemberValue) {
            ((LongMemberValue)memberValue).setValue(((Long)value).longValue());
        } else if (memberValue instanceof FloatMemberValue) {
            ((FloatMemberValue)memberValue).setValue(((Float)value).floatValue());
        } else if (memberValue instanceof DoubleMemberValue) {
            ((DoubleMemberValue)memberValue).setValue(((Double)value).doubleValue());
        } else if (memberValue instanceof ClassMemberValue) {
            ((ClassMemberValue)memberValue).setValue(((Class)value).getName());
        } else if (memberValue instanceof StringMemberValue) {
            ((StringMemberValue)memberValue).setValue((String)value);
        } else if (memberValue instanceof EnumMemberValue) {
            ((EnumMemberValue)memberValue).setValue(((Enum)value).name());
        } else if (memberValue instanceof ArrayMemberValue) {
            CtClass arrayType = type.getComponentType();
            int len = Array.getLength(value);
            MemberValue[] members = new MemberValue[len];
            for (int i = 0; i < len; ++i) {
                members[i] = AlibabaDubboClientValidator.createMemberValue(cp, arrayType, Array.get(value, i));
            }
            ((ArrayMemberValue)memberValue).setValue(members);
        }
        return memberValue;
    }

    public void validate(String methodName, Class<?>[] parameterTypes, Object[] arguments) throws Exception {
        ArrayList groups = new ArrayList();
        String methodClassName = this.clazz.getName() + "$" + AlibabaDubboClientValidator.toUpperMethodName(methodName);
        try {
            Class<?> methodClass = Class.forName(methodClassName, false, Thread.currentThread().getContextClassLoader());
            groups.add(methodClass);
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        HashSet violations = new HashSet();
        Method method = this.clazz.getMethod(methodName, parameterTypes);
        if (method.isAnnotationPresent(MethodValidated.class)) {
            Class[] methodClasses = method.getAnnotation(MethodValidated.class).value();
            groups.addAll(Arrays.asList(methodClasses));
        }
        groups.add(0, Default.class);
        groups.add(1, this.clazz);
        Class[] classGroups = groups.toArray(new Class[0]);
        Object parameterBean = AlibabaDubboClientValidator.getMethodParameterBean(this.clazz, method, arguments);
        if (parameterBean != null) {
            violations.addAll(this.validator.validate(parameterBean, classGroups));
        }
        for (Object arg : arguments) {
            this.validate(violations, arg, classGroups);
        }
        if (!violations.isEmpty()) {
            LOG.error("Failed to validate service: " + this.clazz.getName() + ", method: " + methodName + ", cause: " + violations);
            StringBuilder validateError = new StringBuilder();
            violations.forEach(each -> validateError.append(each.getMessage()).append(","));
            throw new ValidationException(validateError.substring(0, validateError.length() - 1));
        }
    }

    private void validate(Set<ConstraintViolation<?>> violations, Object arg, Class<?> ... groups) {
        if (arg != null && !AlibabaDubboClientValidator.isPrimitives(arg.getClass())) {
            if (arg instanceof Object[]) {
                for (Object item : (Object[])arg) {
                    this.validate(violations, item, groups);
                }
            } else if (arg instanceof Collection) {
                for (Object item : (Collection)arg) {
                    this.validate(violations, item, groups);
                }
            } else if (arg instanceof Map) {
                for (Map.Entry entry : ((Map)arg).entrySet()) {
                    this.validate(violations, entry.getKey(), groups);
                    this.validate(violations, entry.getValue(), groups);
                }
            } else {
                violations.addAll(this.validator.validate(arg, (Class[])groups));
            }
        }
    }
}

