/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.brpc;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.client.brpc.common.annotation.ShenyuBrpcClient;
import org.apache.shenyu.client.brpc.common.dto.BrpcRpcExt;
import org.apache.shenyu.client.core.client.AbstractContextRefreshedEventListener;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.javatuples.Sextet;
import org.springframework.context.ApplicationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;

public class BrpcContextRefreshedEventListener
extends AbstractContextRefreshedEventListener<Object, ShenyuBrpcClient> {
    private final LocalVariableTableParameterNameDiscoverer localVariableTableParameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private ApplicationContext applicationContext;

    public BrpcContextRefreshedEventListener(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        super(clientConfig, shenyuClientRegisterRepository);
    }

    protected Sextet<String[], String, String, ApiHttpMethodEnum[], RpcTypeEnum, String> buildApiDocSextet(Method method, Annotation annotation, Map<String, Object> beans) {
        ShenyuBrpcClient shenyuBrpcClient = (ShenyuBrpcClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuBrpcClient.class);
        if (Objects.isNull(shenyuBrpcClient)) {
            return null;
        }
        String produce = "*/*";
        String consume = "*/*";
        String[] values = new String[]{shenyuBrpcClient.value()};
        ApiHttpMethodEnum[] apiHttpMethodEnums = new ApiHttpMethodEnum[]{ApiHttpMethodEnum.NOT_HTTP};
        String version = "v0.01";
        return Sextet.with((Object)values, (Object)consume, (Object)produce, (Object)apiHttpMethodEnums, (Object)RpcTypeEnum.BRPC, (Object)version);
    }

    protected Map<String, Object> getBeans(ApplicationContext context) {
        this.applicationContext = context;
        return context.getBeansWithAnnotation(ShenyuBrpcClient.class);
    }

    protected URIRegisterDTO buildURIRegisterDTO(ApplicationContext context, Map<String, Object> beans) {
        return URIRegisterDTO.builder().contextPath(this.getContextPath()).appName(this.getAppName()).rpcType(RpcTypeEnum.BRPC.getName()).host(this.getHost()).port(Integer.valueOf(Integer.parseInt(this.getPort()))).build();
    }

    protected String buildApiSuperPath(Class<?> clazz, ShenyuBrpcClient shenyuBrpcClient) {
        if (Objects.nonNull(shenyuBrpcClient) && !StringUtils.isBlank((CharSequence)shenyuBrpcClient.path())) {
            return shenyuBrpcClient.path();
        }
        return "";
    }

    protected Class<ShenyuBrpcClient> getAnnotationType() {
        return ShenyuBrpcClient.class;
    }

    protected String buildApiPath(Method method, String superPath, ShenyuBrpcClient shenyuBrpcClient) {
        return superPath.contains("*") ? this.pathJoin(new String[]{this.getContextPath(), superPath.replace("*", ""), method.getName()}) : this.pathJoin(new String[]{this.getContextPath(), superPath, shenyuBrpcClient.path()});
    }

    protected void handleClass(Class<?> clazz, Object bean, ShenyuBrpcClient shenyuBrpcClient, String superPath) {
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getDeclaredMethods(clazz)) {
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(bean, shenyuBrpcClient, superPath, clazz, method));
        }
    }

    protected MetaDataRegisterDTO buildMetaDataDTO(Object bean, ShenyuBrpcClient shenyuBrpcClient, String superPath, Class<?> clazz, Method method) {
        String serviceName = clazz.getInterfaces().length > 0 ? clazz.getInterfaces()[0].getName() : clazz.getName();
        String path = superPath;
        String desc = shenyuBrpcClient.desc();
        String host = IpUtils.isCompleteHost((String)this.getHost()) ? this.getHost() : IpUtils.getHost((String)this.getHost());
        String configRuleName = shenyuBrpcClient.ruleName();
        String ruleName = "".equals(configRuleName) ? path : configRuleName;
        int port = StringUtils.isBlank((CharSequence)this.getPort()) ? -1 : Integer.parseInt(this.getPort());
        String methodName = method.getName();
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        return MetaDataRegisterDTO.builder().appName(this.getAppName()).serviceName(serviceName).methodName(methodName).contextPath(this.getContextPath()).path(path).port(Integer.valueOf(port)).host(host).pathDesc(desc).ruleName(ruleName).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.BRPC.getName()).rpcExt(this.buildRpcExt(method)).enabled(shenyuBrpcClient.enabled()).build();
    }

    private String buildRpcExt(Method method) {
        ArrayList<BrpcRpcExt.RpcExt> list = new ArrayList<BrpcRpcExt.RpcExt>();
        list.add(this.build(method));
        BrpcRpcExt buildList = new BrpcRpcExt(list);
        return GsonUtils.getInstance().toJson((Object)buildList);
    }

    private BrpcRpcExt.RpcExt build(Method method) {
        String[] paramNames = this.localVariableTableParameterNameDiscoverer.getParameterNames(method);
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        if (paramNames != null && paramNames.length > 0) {
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int i = 0; i < paramNames.length; ++i) {
                params.add((Pair<String, String>)Pair.of((Object)paramTypes[i].getName(), (Object)paramNames[i]));
            }
        }
        return new BrpcRpcExt.RpcExt(method.getName(), params);
    }
}

