/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.loadbalancer.cache.UpstreamCheckTask;
import org.apache.shenyu.loadbalancer.entity.Upstream;

public final class UpstreamCacheManager {
    private static final UpstreamCacheManager INSTANCE = new UpstreamCacheManager();
    private static final Map<String, List<Upstream>> UPSTREAM_MAP = Maps.newConcurrentMap();
    private UpstreamCheckTask task;
    private Boolean checkEnable;
    private int checkTimeout;
    private int checkInterval;
    private int healthyThreshold;
    private int unhealthyThreshold;
    private Boolean printEnable;
    private Integer printInterval;

    private UpstreamCacheManager() {
        this.initHealthCheck();
    }

    private void initHealthCheck() {
        ShenyuConfig shenyuConfig = Optional.ofNullable((ShenyuConfig)Singleton.INST.get(ShenyuConfig.class)).orElse(new ShenyuConfig());
        ShenyuConfig.UpstreamCheck upstreamCheck = shenyuConfig.getUpstreamCheck();
        this.checkEnable = upstreamCheck.getEnabled();
        this.checkTimeout = upstreamCheck.getTimeout();
        this.healthyThreshold = upstreamCheck.getHealthyThreshold();
        this.unhealthyThreshold = upstreamCheck.getUnhealthyThreshold();
        this.checkInterval = upstreamCheck.getInterval();
        this.printEnable = upstreamCheck.getPrintEnabled();
        this.printInterval = upstreamCheck.getPrintInterval();
        this.createTask();
        this.scheduleHealthCheck();
    }

    private void createTask() {
        this.task = new UpstreamCheckTask(this.checkInterval);
        this.task.setCheckTimeout(this.checkTimeout);
        this.task.setHealthyThreshold(this.healthyThreshold);
        this.task.setUnhealthyThreshold(this.unhealthyThreshold);
    }

    private void scheduleHealthCheck() {
        if (this.checkEnable.booleanValue()) {
            this.task.schedule();
            if (this.printEnable.booleanValue()) {
                ThreadFactory printFactory = ShenyuThreadFactory.create((String)"upstream-health-print", (boolean)true);
                new ScheduledThreadPoolExecutor(1, printFactory).scheduleWithFixedDelay(this.task::print, this.printInterval.intValue(), this.printInterval.intValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public static UpstreamCacheManager getInstance() {
        return INSTANCE;
    }

    public List<Upstream> findUpstreamListBySelectorId(String selectorId) {
        return this.task.getHealthyUpstream().get(selectorId);
    }

    public void removeByKey(String key) {
        UPSTREAM_MAP.remove(key);
        this.task.triggerRemoveAll(key);
    }

    public void submit(String selectorId, List<Upstream> upstreamList) {
        List validUpstreamList = upstreamList.stream().filter(Upstream::isStatus).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(validUpstreamList)) {
            List existUpstream = UPSTREAM_MAP.computeIfAbsent(selectorId, k -> Lists.newArrayList());
            existUpstream.stream().filter(upstream -> !validUpstreamList.contains(upstream)).forEach(upstream -> this.task.triggerRemoveOne(selectorId, (Upstream)upstream));
            validUpstreamList.stream().filter(upstream -> !existUpstream.contains(upstream)).forEach(upstream -> this.task.triggerAddOne(selectorId, (Upstream)upstream));
            UPSTREAM_MAP.put(selectorId, validUpstreamList);
        } else {
            UPSTREAM_MAP.remove(selectorId);
            this.task.triggerRemoveAll(selectorId);
        }
    }
}

