/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.spi;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.spi.AbstractLoadBalancer;
import org.apache.shenyu.spi.Join;

@Join
public class LeastActiveLoadBalance
extends AbstractLoadBalancer {
    private Map<String, Integer> countMap = new ConcurrentHashMap<String, Integer>();

    @Override
    protected Upstream doSelect(List<Upstream> upstreamList, String ip) {
        ConcurrentHashMap domainList = new ConcurrentHashMap();
        upstreamList.stream().forEach(upstream -> domainList.put(upstream.buildDomain(), upstream));
        this.countMap.keySet().forEach(key -> {
            if (!domainList.keySet().contains(key)) {
                this.countMap.remove(key);
            }
        });
        for (Upstream upstream2 : upstreamList) {
            if (this.countMap.get(upstream2.buildDomain()) == null) {
                this.countMap.put(upstream2.buildDomain(), 1);
                return upstream2;
            }
            this.countMap.put(upstream2.buildDomain(), this.countMap.get(upstream2.buildDomain()) + 1);
        }
        AtomicReference<String> leastDomainUrl = new AtomicReference<String>(upstreamList.get(0).buildDomain());
        this.countMap.keySet().forEach(key -> {
            if (this.countMap.get(key) < this.countMap.get(leastDomainUrl)) {
                leastDomainUrl.set((String)key);
            }
        });
        return (Upstream)domainList.get(leastDomainUrl);
    }
}

